#ifndef INCLUDED_SERIAL_TO_I2C_H
#define INCLUDED_SERIAL_TO_I2C_H

#include "mbed.h"

// Serial通信で得たデータをI2Cで渡す
class SerialToI2C{
public:
    enum ActionType{
        STOP    = 0x00, // 0000 0000(2)
        MOVE    = 0x08, // 0000 1000(2)
        ROLL    = 0x10, // 0001 0000(2)
        SHOOT   = 0x18  // 0001 1000(2)
    };
    
    enum AimState{
        OWN_POLE            = 0x00,
        CENTER_MIDDLE_POLE  = 0x40,
        CENTER_SIDE_POLE    = 0x80,
        ENEMYS_POLE         = 0xC0
    };
    
    enum StopDetailType{
        NO_OPERATION,
        INCREMENT,
        DECREMENT,
        LOW_SPEED,
        HIGH_SPEED
    };

    static void create( PinName sda, PinName scl, PinName tx, PinName rx ){
        if ( mInstance == NULL ){
            mInstance = new SerialToI2C( sda, scl, tx, rx );
        }
    }
    static SerialToI2C* getInstance(){
        return mInstance;
    }
    
    void update();
    
private:
    static SerialToI2C* mInstance;
    // 実体なし
    SerialToI2C( SerialToI2C& a );
    void operator = ( SerialToI2C& a );
    
    SerialToI2C( PinName sda, PinName scl, PinName tx, PinName rx );
    ~SerialToI2C(){
        delete mXBee;
        delete mI2C;
    }
    
    void recvSerial();
    void stringToI2CData();
    void updateI2CSlave();
    
    static const PinName mAddressDeciderPinName[ 4 ];
    static const char mControlMask;
    static const char mDetailMask;
    static const char mDutyMask;
    
    char mAddress;
    
    RawSerial* mXBee;
    I2CSlave* mI2C;
    
    char mRecv;
    char mI2CSentData;
    bool mIsI2CSentDataChangeable;
    
    char mMoveDirection;
    float mMoveCoeff;
    float mRoll;
    ActionType mActionType;
    AimState mAimState;
    StopDetailType mStopDetailType;
    bool mIsSupplying;
    
    DigitalOut* mLED;
};

#endif
