#include "I2CDevice.h"
#include "OBROT.h"
#include "mbed.h"
#include "Robot.h"

I2C* I2CDevice::mI2C[] = {
    NULL,
    NULL,
    NULL
};
const PinName I2CDevice::mSDA[] = {
    D14,
    D3,
    D5
};
const PinName I2CDevice::mSCL[] = {
    D15,
    D6,
    D7
};
const uint32_t I2CDevice::mNumOfI2C = 3;

I2C* I2CDevice::getI2C() const{
    for ( int i = I2CDeviceID::STEERING_MOTOR_0; i <= I2CDeviceID::STEERING_SERVO_2; ++i ){
        // Steering
        if ( mAddress == OBROT::mI2CDeviceAddress[ i ] ){
            return mI2C[ 0 ];
        }
    }
    for ( int i = I2CDeviceID::ANGLE_MANAGER; i < Robot::getNumOfI2CDevices(); ++i ){
        // NOT ( Steering and XBee )
        if ( mAddress == OBROT::mI2CDeviceAddress[ i ] ){
            return mI2C[ 1 ];
        }
    }
    
    // XBee
    return mI2C[ 2 ];
}
