#ifndef INCLUDED_I2CDEVICE_H
#define INCLUDED_I2CDEVICE_H

#include "mbed.h"

class I2CDevice{
public:
    static void resetI2C(){
        destroyI2C();
        createI2C();
    }
    static void createI2C(){
        for ( int i = 0; i < mNumOfI2C; ++i ){
            mI2C[ i ] = new I2C( mSDA[ i ], mSCL[ i ] );
        }
    }
    static void destroyI2C(){
        for ( int i = 0; i < mNumOfI2C; ++i ){
            delete mI2C[ i ];
        }
    }

    I2CDevice( char address ) : mAddress( address ){
    }
    
    virtual int write(){
        return 0;
    }
    virtual int read(){
        return 0;
    }
    
    void writeI2C(){
        if ( write() ){
            resetI2C();
        }
    }
    
    void readI2C(){
        if ( read() ){
            resetI2C();
        }
    }
    
    int write( char* data, size_t len ) const{
        return getI2C()->write( mAddress, data, len );
    }
    int read( char* data, size_t len ) const{
        return getI2C()->read( mAddress, data, len );
    }
    
    int writeReg( char devAddr, char regAddr, char data ){
        char d[ 2 ] = { regAddr, data };
        return getI2C()->write( devAddr, d, 2 );
    }
    
    int readReg( char devAddr, char regAddr, char* data, size_t len ){
        regAddr |= 0x80;
        getI2C()->write( devAddr, &regAddr, 1, true );
        return getI2C()->read( devAddr | 1, data, len );
    }
    
protected:
    I2C* getI2C() const;

    static const uint32_t mNumOfI2C;
    static const PinName mSDA[];
    static const PinName mSCL[];
    static I2C* mI2C[];
    
    const char mAddress;
};

#endif
