#ifndef INCLUDED_ROBOT_H
#define INCLUDED_ROBOT_H

#include "mbed.h"
class I2CDevice;

class Robot{
public:
    static uint32_t getNumOfI2CDevices(){
        return mNumOfI2CDevices;
    }
    void update();
    
protected:
    static const uint32_t mNumOfI2CDevices;
    I2CDevice** mI2CDevice;
    
private:
    virtual void updateAction() = 0;
    void readI2CDevice();
    void writeI2CDevice();
    
};

#endif
