#include "mbed.h"
#include "Robot.h"
#include "I2CDevice.h"

// XBee :                       ----  1
// Steering {
//  I2CMotor * 3, I2CServo * 3  ----  6
//  I2CServo * 1                ----  1
// }
// ShootingSystem {
//  Shooter:                    ----  1
//  AmmoPusher:                 ----  1
//  AmmoSupplier:               ----  1
//  I2CServo:                   ----  1
// }
const uint32_t Robot::mNumOfI2CDevices = 12;

void Robot::update(){
    readI2CDevice();
    updateAction();
    writeI2CDevice();
}

void Robot::writeI2CDevice(){
    for ( int i = 0; i < mNumOfI2CDevices; ++i ){
        mI2CDevice[ i ]->writeI2C();
    }
}

void Robot::readI2CDevice(){
    for ( int i = 0; i < mNumOfI2CDevices; ++i ){
        mI2CDevice[ i ]->readI2C();
    }
}
