#include "mbed.h"
#include "PWMOut.h"

PWMOut::PWMOut( PinName p ){
    mPWM    = new PwmOut( p );
    mTimer  = new Timer;
    mTimer->start();
    mPeriod_us  = 20 * 1000;
    mNextDuty   = 0.0f;
}

void PWMOut::setDuty( float duty ){
    mNextDuty = duty;
    
    if ( mTimer->read_us() > mPeriod_us ){
        mPWM->write( mNextDuty );
        mTimer->reset();
    }
}

void PWMOut::setPeriod_sec( float period ){
    setPeriod_us( static_cast< uint32_t >( period * 1000.0f * 1000.0f ) );
}

void PWMOut::setPeriod_us( uint32_t period ){
    mPWM->period_us( period );
}
