#ifndef INCLUDED_MBED_STL_PID_H
#define INCLUDED_MBED_STL_PID_H

#include "mbed.h"

namespace mbed_stl {

// ErrTypeは偏差の型．MVTypeは操作量の型．KTypeは係数の型．
template <typename ErrType, typename MVType = ErrType, typename KType = ErrType>
class PID{
public:
    PID(KType kp, KType ki, KType kd);
    
    MVType update(ErrType error);
    
private:
    const KType kp_;    // 比例制御係数
    const KType ki_;    // 積分制御係数
    const KType kd_;    // 微分制御係数
    
    ErrType integral_;
    ErrType prev_error_;
    
    Timer timer_;
    float prev_time_us_;
};

} /* namespace mbed_stl */

#include "PID_impl.hpp"

typedef mbed_stl::PID<float> PID_f;
typedef mbed_stl::PID<double> PID_d;

#endif
