#include "mbed.h"
#include "OBROT.h"
#include "I2CMotor.h"
#include "Steering.h"
#include "XBee.h"
#include "I2CServo.h"
#include "Command.h"
#include "ShootingSystem.h"
#include "Shooter.h"
#include "AmmoPusher.h"
#include "AmmoSupplier.h"
#include "Robot.h"

OBROT* OBROT::mInstance = NULL;

const char OBROT::mI2CDeviceAddress[] = {
    // ステアリング駆動輪
    0xA0 | ( 0x01 << 1 ),
    0xA0 | ( 0x02 << 1 ),
    0xA0 | ( 0x03 << 1 ),
    // ステアリングサーボ
    0xA0 | ( 0x04 << 1 ),
    0xA0 | ( 0x05 << 1 ),
    0xA0 | ( 0x06 << 1 ),
    // XBee
    0xA0 | ( 0x07 << 1 ),
    // AngleManagerServo
    0xA0 | ( 0x08 << 1 ),
    // Shooter
    0xA0 | ( 0x09 << 1 ),
    // AmmoPusher
    0xA0 | ( 0x0A << 1 ),
    // AmmoSupplier
    0xA0 | ( 0x0B << 1 ),
    // PositionManager
    0xA0 | ( 0x0D << 1 )
};

OBROT::OBROT(){
    mI2CDevice = new I2CDevice*[ getNumOfI2CDevices() ];
    
    I2CDevice::createI2C();
    
    initXBee();
    
    I2CMotor** i2cMotor = initSteeringTire();
    I2CServo** i2cServo = initSteeringServo();
    
    I2CServo*       angleManagerServo   = initAngleManager();
    AmmoPusher*     ammoPusher          = initAmmoPusher();
    AmmoSupplier*   ammoSupplier        = initAmmoSupplier();
    Shooter*        shooter             = initShooter();
    I2CServo*       positionManager     = initPositionManager();
    
    mSteering       = new Steering( i2cMotor, i2cServo );
    mShootingSystem = new ShootingSystem( angleManagerServo, ammoPusher,
                                          ammoSupplier, shooter, positionManager );
}

OBROT::~OBROT(){
    delete[] mI2CDevice;
    delete mSteering;
    delete mShootingSystem;
}

void OBROT::updateAction(){
    Command command = mXBee->createCommand();
    
    mShootingSystem->update( command );
    mSteering->update( command );
}

I2CServo** OBROT::initSteeringServo(){
    I2CServo** i2cServo = new I2CServo*[ Steering::mNumOfTire ];
    
    for ( int i = 0; i < Steering::mNumOfTire; ++i ){
        i2cServo[ i ] = new I2CServo( mI2CDeviceAddress[ i + Steering::mNumOfTire ] );
        mI2CDevice[ i + Steering::mNumOfTire ] = i2cServo[ i ];
    }
    
    return i2cServo;
}

I2CMotor** OBROT::initSteeringTire(){
    I2CMotor** i2cMotor = new I2CMotor*[ Steering::mNumOfTire ];
    
    for ( int i = 0; i < Steering::mNumOfTire; ++i ){
        mI2CDevice[ i ] = i2cMotor[ i ] = new I2CMotor( mI2CDeviceAddress[ i ] );
    }
    
    return i2cMotor;
}

XBee* OBROT::initXBee(){
    mI2CDevice[ I2CDeviceID::XBEE ] = mXBee =  new XBee( mI2CDeviceAddress[ I2CDeviceID::XBEE ] );
    return mXBee;
}

I2CServo* OBROT::initAngleManager(){
    I2CServo* angleManagerServo = new I2CServo( mI2CDeviceAddress[ I2CDeviceID::ANGLE_MANAGER ] );
    mI2CDevice[ I2CDeviceID::ANGLE_MANAGER ] = angleManagerServo;
    return angleManagerServo;
}

AmmoPusher* OBROT::initAmmoPusher(){
    AmmoPusher* ammoPusher = new AmmoPusher( mI2CDeviceAddress[ I2CDeviceID::AMMO_PUSHER ] );
    mI2CDevice[ I2CDeviceID::AMMO_PUSHER ] = ammoPusher;
    return ammoPusher;
}

AmmoSupplier* OBROT::initAmmoSupplier(){
    AmmoSupplier* ammoSupplier = new AmmoSupplier( mI2CDeviceAddress[ I2CDeviceID::AMMO_SUPPLIER ] );
    mI2CDevice[ I2CDeviceID::AMMO_SUPPLIER ] = ammoSupplier;
    return ammoSupplier;
}

Shooter* OBROT::initShooter(){
    Shooter* shooter = new Shooter( mI2CDeviceAddress[ I2CDeviceID::SHOOTER ] );
    mI2CDevice[ I2CDeviceID::SHOOTER ] = shooter;
    return shooter;
}

I2CServo* OBROT::initPositionManager(){
    I2CServo* positionManager = new I2CServo( mI2CDeviceAddress[ I2CDeviceID::POSITION_MANAGER ] );
    mI2CDevice[ I2CDeviceID::POSITION_MANAGER ] = positionManager;
    return positionManager;
}
