#ifndef INCLUDED_OBROT_H
#define INCLUDED_OBROT_H

#include "mbed.h"
#include "Robot.h"

class XBee;
class Steering;
class ShootingSystem;
class I2CServo;
class I2CMotor;
class Shooter;
class AmmoSupplier;
class AmmoPusher;
    
namespace I2CDeviceID{
    enum ID{
        STEERING_MOTOR_0    = 0,
        STEERING_MOTOR_1    = 1,
        STEERING_MOTOR_2    = 2,
        STEERING_SERVO_0    = 3,
        STEERING_SERVO_1    = 4,
        STEERING_SERVO_2    = 5,
        XBEE                = 6,
        ANGLE_MANAGER       = 7,
        SHOOTER             = 8,
        AMMO_PUSHER         = 9,
        AMMO_SUPPLIER       = 10,
        POSITION_MANAGER    = 11
    };
}

class OBROT : public Robot{
public:
    static OBROT* getInstance(){
        if ( mInstance == NULL ){
            mInstance = new OBROT;
        }
        
        return mInstance;
    }
    
    static const char mI2CDeviceAddress[];
    
private:
    OBROT();
    ~OBROT();
    
    virtual void updateAction();
    
    I2CServo**      initSteeringServo();
    I2CMotor**      initSteeringTire();
    XBee*           initXBee();
    I2CServo*       initAngleManager();
    AmmoPusher*     initAmmoPusher();
    AmmoSupplier*   initAmmoSupplier();
    Shooter*        initShooter();
    I2CServo*       initPositionManager();
    
    static OBROT* mInstance;
    
    Steering* mSteering;
    ShootingSystem* mShootingSystem;
    XBee* mXBee;
};

#endif
