#include "mbed.h"
#include "GMD.hpp"

char read_din() {
    const size_t din_num = 4;
    DigitalIn din[] = {
        DigitalIn(dp26),
        DigitalIn(dp25),
        DigitalIn(dp18),
        DigitalIn(dp17)
    };
    
    char address = 0;
    for (size_t i = 0; i < din_num; ++i) {
        address |= din[i].read() << i;
    }
    return address;
}

int main(){
    GMD<5, 95> md(dp1, dp2, dp9); // Duty比の範囲を5%~95%に制限
    //md.set_frequency_kHz(10.0f);  もしスイッチング周波数を変更したかったらここを使う
    while (true){
        switch (read_din()) {
            case 0x00:
                md.set(0.0f);
                break;
            
            case 0x01:
                md.set(0.5f);
                break;
                
            case 0x02:
                md.set(-0.5f);
                break;
            
            case 0x03:
                md.release();
                break;
        }
    }
}
