#include "mbed.h"
#include "GMD.hpp"

char read_address() {
    const size_t din_num = 4;
    DigitalIn din[] = {
        DigitalIn(dp26),
        DigitalIn(dp25),
        DigitalIn(dp18),
        DigitalIn(dp17)
    };
    
    char address = 0;
    size_t address_offset = 0x08 << 1;
    for (size_t i = 0; i < din_num; ++i) {
        address |= din[i].read() << (i + 1);
    }
    return address + address_offset;
}

int main(){
    const float timeout_ms = 300.0f;
    I2CSlave i2c(dp5, dp27);
    Timer timer;
    i2c.address(read_address());
    GMD<5, 95> md(dp1, dp2, dp9); // Duty比の範囲を5%~95%に制限
    //md.set_frequency_kHz(10.0f);  もしスイッチング周波数を変更したかったらここを使う
    
    timer.start();
    
    while (true){
        if (timer.read_ms() > timeout_ms) {
            // I2Cの通信がタイムアウトしたなら開放
            md.release();
        }
        
        char buf;
        switch (i2c.receive()){
            case I2CSlave::ReadAddressed:
                timer.reset();
                break;
            
            case I2CSlave::WriteGeneral:
                timer.reset();
                break;
            
            case I2CSlave::WriteAddressed:
                timer.reset();
                i2c.read(&buf, 1);
                md.set(static_cast<int8_t>(buf) / 127.0f);
                break;
                
            case I2CSlave::NoData:
                break;
        }
    }
}
