#include "Motor.h"

const float Motor::mMinDuty = 0.3f;
const float Motor::mMaxDuty = 0.7f;

Motor::Motor( PinName p0, PinName p1, PinName p2, PinName p3 ){
    mActionType = RELEASE;
    mDuty       = mMinDuty;
    
    mPin0_PWM = new PwmOut( p0 );
    mPin1_D   = new DigitalOut( p1 );
    mPin2_D   = new DigitalOut( p2 );
    mPin3_PWM = new PwmOut( p3 );
    
    update();
}

void Motor::update(){
    switch ( mActionType ){
        case FORWARD:
            mPin0_PWM->write( 1.0f - mDuty );
            mPin1_D->write( 0 );
            mPin2_D->write( 1 );
            mPin3_PWM->write( 1.0f );
            break;
        
        case BACKWARD:
            mPin0_PWM->write( 1.0f );
            mPin1_D->write( 1 );
            mPin2_D->write( 0 );
            mPin3_PWM->write( 1.0f - mDuty );
            break;
            
        case BRAKE:
            mPin0_PWM->write( 0.0f);
            mPin1_D->write( 1 );
            mPin2_D->write( 1 );
            mPin3_PWM->write( 0.0f );
            break;
            
        case RELEASE:
            mPin0_PWM->write( 1.0f );
            mPin3_PWM->write( 1.0f );
            break;
    }
}
