#ifndef INCLUDED_MOTOR_H
#define INCLUDED_MOTOR_H

#include "mbed.h"

// p0    p3
// |     |
// |--M--|
// |     |
// p1    p2
class Motor{
public:
    enum ActionType{
        FORWARD,
        BACKWARD,
        BRAKE,
        RELEASE
    };

    Motor( PinName p0, PinName p1, PinName p2, PinName p3 );
    ~Motor();
    
    void setPercent( float p ){
        setDuty( mMinDuty + ( mMaxDuty - mMinDuty ) * p );
    }
    void setDuty( float d ){
        if ( d > mMaxDuty ){
            d = mMaxDuty;
        } else if ( d < mMinDuty ){
            d = mMinDuty;
        }
        mDuty = d;
        
        update();
    }
    void setActionType( ActionType a ){
        mActionType = a;
        update();
    }
    
private:
    void update();

    static const float mMinDuty;
    static const float mMaxDuty;

    float mDuty;
    ActionType mActionType;
    
    PwmOut* mPin0_PWM;
    DigitalOut* mPin1_D;
    DigitalOut* mPin2_D;
    PwmOut* mPin3_PWM;
};

#endif