#ifndef INCLUDED_I2C_SERVO_H
#define INCLUDED_I2C_SERVO_H

#include "mbed.h"
#include "I2CDevice.h"

class I2CServo : public I2CDevice{
public:
    I2CServo( char address );
    
    void setTargetPosition( float p );
    
    bool hasStopped(){
        return mHasStopped;
    }
    float getPosition(){
        return mPosition;
    }
    
    void stop(){
        mTargetPosition = mPosition;
        mHasStopped = true;
    }
    
    virtual int write();
    virtual int read();
    
private:
    static const float mAllowableError;
    float mTargetPosition;
    bool mHasStopped;
    float mPosition;
};

#endif