#ifndef INCLUDED_I2C_MOTOR_H
#define INCLUDED_I2C_MOTOR_H

#include "I2CDevice.h"
#include "mbed.h"

class I2CMotor : public I2CDevice{
public:
    enum ActionType{
        FORWARD,
        REVERSE,
        BRAKE,
        RELEASE,
    };
    I2CMotor( char address );
    
    void setActionType( ActionType action ){
        mActionType = action;
    }
    void setDuty( float duty ){
        if ( duty > mMaxDuty ){
            duty = mMaxDuty;
        } else if ( duty < mMinDuty ){
            duty = mMinDuty;
        }
        
        mDuty = duty;
    }
    void setPercent( float p ){
        setDuty( p * mMaxDuty + ( 1.0f - p ) * mMinDuty );
    }
    ActionType getActionType() const{
        return mActionType;
    }
    float getDuty() const{
        return mDuty;
    }
    
    float getMaxDuty() const{
        return mMaxDuty;
    }
    float getMinDuty() const{
        return mMinDuty;
    }
    
protected:
    virtual int write();
private:
    ActionType mActionType;
    float mDuty;
    
    float mMaxDuty;
    float mMinDuty;
};

#endif