#include "I2CMotor.h"
#include "I2CDevice.h"
#include "mbed.h"

I2CMotor::I2CMotor( char address ) : I2CDevice( address ){
    mActionType = BRAKE;
    mDuty       = 0;
    
    char dutyLimit[ 2 ];
    
    if ( I2CDevice::read( ( char* )dutyLimit, ( size_t )2 ) ){
        I2CDevice::resetI2C();
    }
    //read( ( char* )dutyLimit, ( size_t )2 );
    
    mMinDuty = dutyLimit[ 0 ];
    mMinDuty /= 255.0f;
    
    mMaxDuty = dutyLimit[ 1 ];
    mMaxDuty /= 255.0f;
}


int I2CMotor::write(){
    char trans[] = {
        static_cast< char >( mActionType ),
        static_cast< char >( mDuty * 255.0f )
    };
    return I2CDevice::write( trans, 2 );
}
