#ifndef INCLUDED_GMD_H
#define INCLUDED_GMD_H

#include "mbed.h"
#include "FastPWM.h"

template <size_t MIN, size_t MAX>
class GMD {
public:
    GMD(PinName p0, PinName p1, PinName shut_down);
    void set_frequency_kHz(float f_kHz);
    
    float operator=(float p);
    float set(float p);
    void release();
    
private:
    static const float _frequency_to_tick_coeff;
    static const uint32_t _default_frequency_kHz;
    static const float _threshold;

    FastPWM* _pwm[2];
    DigitalOut _shut_down;
};

#include "GMD_impl.hpp"

typedef GMD<0, 95> basic_motor_driver;
 
#endif