#ifndef INCLUDED_COMMAND_H
#define INCLUDED_COMMAND_H

#include "Steering.h"
#include "Shooter.h"
#include "ShootingSystem.h"

class Command{
public:
    enum ShotTargetID{
        OWN_POLE_ID,
        CENTER_MIDDLE_POLE_ID,
        CENTER_SIDE_POLE_ID,
        ENEMYS_POLE_ID
    };
    
    Command();
    Command( Steering::ActionType steeringAction,
             ShootingSystem::AimState aimState,
             float moveDirection_rad, float angleAdjust_deg,
             float moveDuty, float roll, bool isSupplying );
    
    void setSteeringActionType( Steering::ActionType action ){
        mSteeringActionType = action;
    }
    void setAimStateAndAimParam( ShootingSystem::AimState aimState );
    void setMoveDirection_rad( float moveDirection_rad ){
        mMoveDirection_rad = moveDirection_rad;
    }
    void setMoveDuty( float moveDuty ){
        mMoveDuty = moveDuty;
    }
    void setRollCoeff( float rollCoeff ){
        mRollCoeff = rollCoeff;
    }
    void setAngleOfShooting( float angle ){
        mShootingAngle_deg = angle;
    }
    void setAngleAdjust_deg( float angle_deg ){
        mAngleAdjust_deg = angle_deg;
    }
    void setShooterPosition( float pos ){
        mShooterPosition = pos;
    }
    
    Steering::ActionType getSteeringActionType(){
        return mSteeringActionType;
    }
    ShootingSystem::AimState getAimState(){
        return mAimState;
    }
    float getMoveDirection_rad(){
        return mMoveDirection_rad;
    }
    float getMoveDuty(){
        return mMoveDuty;
    }
    float getRollCoeff(){
        return mRollCoeff;
    }
    float getShootingAngleAnalog(){
        return angleToAnalog( mShootingAngle_deg );
    }
    Shooter::ActionType getShootVoltage(){
        return mShootVoltage;
    }
    float getAngleAdjust_deg(){
        return mAngleAdjust_deg;
    }
    float getShooterPosition(){
        return mShooterPosition;
    }
    bool isShooting(){
        return mIsShooting;
    }
    bool isSupplying(){
        return mIsSupplying;
    }
    
private:
    float angleToAnalog( float angle_deg ){
        return mAngleToAnalogCoeffA * angle_deg + mAngleToAnalogCoeffB;
    }

    static const float mShootingAngleTable[];
    static const float mAngleToAnalogCoeffA;
    static const float mAngleToAnalogCoeffB;
    static const float mMaxAngle_deg;
    static const float mMinAngle_deg;
    static const float mShooterPositionTable[];
    
    Steering::ActionType mSteeringActionType;
    Shooter::ActionType mShootVoltage;
    ShootingSystem::AimState mAimState;
    float mMoveDirection_rad;
    float mMoveDuty;
    float mRollCoeff;
    float mShootingAngle_deg;
    float mAngleAdjust_deg;
    float mShooterPosition;
    bool mIsShooting;
    bool mIsSupplying;
};

#endif
