#include "mbed.h"
#include "AmmoSupplier.h"
#include "I2CMotor.h"
#include "ShootingSystem.h"

AmmoSupplier::AmmoSupplier( char address ) : I2CDevice( address ){
    mSupplyCommand  = false;
    mIsSupplying    = false;
    mHasSupplied    = false;
}

int AmmoSupplier::write(){
    int val = 0;
    
    if ( mSupplyCommand ){
        char buf = 1;
        val = I2CDevice::write( &buf, 1 );
        mSupplyCommand = false;
    }
    
    return val;
}

int AmmoSupplier::read(){
    char buf;
    int val = I2CDevice::read( &buf, 1 );
    
    mHasSupplied = ( mIsSupplying && !buf );
    mIsSupplying = buf;
    
    //printf( "%d\n", buf );
    
    /*
    if ( mHasSupplied ){
        wait( 1.0f );
    }
    */
    
    return val;
}
