#ifndef INCLUDED_AMMO_PUSHER_H
#define INCLUDED_AMMO_PUSHER_H

#include "mbed.h"
#include "I2CDevice.h"

class AmmoPusher : public I2CDevice{
public:
    enum ActionType{
        NO_OPERATION,
        DRAWING,
        PUSHING
    };
    enum State{
        BETWEEN,
        HAS_FINISHED_DRAWING,
        HAS_FINISHED_PUSHING
    };

    AmmoPusher( char address );
    
    void push(){
        setActionType( PUSHING );
    }
    void draw(){
        setActionType( DRAWING );
    }
    void setActionType( ActionType action ){
        mActionType = action;
    }
    State getState(){
        return mState;
    }
    bool isWorking(){
        return ( ( mState == BETWEEN ) && ( mActionType != NO_OPERATION ) );
    }
    bool hasPushed(){
        return ( mState ==  HAS_FINISHED_PUSHING );
    }
    bool hasDrawn(){
        return ( mState ==  HAS_FINISHED_DRAWING );
    }
    
    virtual int write();
    virtual int read();
    
private:
    ActionType mActionType;
    State mState;
};

#endif
