#include "AmmoPusher.h"
#include "mbed.h"
#include "I2CMotor.h"
#include "I2CDevice.h"

AmmoPusher::AmmoPusher( char address ) : I2CDevice( address ){
    mState      = BETWEEN;
    mActionType = NO_OPERATION;
}

int AmmoPusher::write(){
    char buf = mActionType;
    return I2CDevice::write( &buf, 1 );
}

int AmmoPusher::read(){
    char buf;
    int val = I2CDevice::read( &buf, 1 );
    mState = static_cast< State >( buf );
    return val;
}
