#include "mbed.h"
#include "uStep.h"
#include "TextLCD.h"
#include "Projekt.h"
#define THERMISTORNOMINAL 100000
#define TEMPERATURENOMINAL 25
#define BCOEFFICIENT 3950
#define SERIESRESISTOR 10000
TextLCD lcd(PTE0, PTE1, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
Ticker ticki;
AnalogIn Thermistor(A5);
DigitalIn in0(PTB0);
DigitalIn in1(PTB1);
DigitalIn in2(PTB2);
DigitalIn in3(PTD7);
DigitalIn buttondown(PTE30);
DigitalIn buttonup(PTC2);
DigitalOut andrijinkriz1(PTE29);
DigitalOut andrijinkriz2(PTE23);

uStep motor(PTB8, PTB9,PTB10, PTB11);

float get_temperature()
{
    float temperature, resistance;
    float steinhart;
    int a;

    a = Thermistor.read_u16();       // Read 16bit Analog value


    /* Calculate the resistance of the thermistor from analog votage read. */
    resistance = (float) SERIESRESISTOR / ((65536.0 / a) - 1);
    steinhart = resistance / THERMISTORNOMINAL;         // (R/Ro)
    steinhart = log(steinhart);                         // ln(R/Ro)
    steinhart /= BCOEFFICIENT;                          // 1/B * ln(R/Ro)
    steinhart += 1.0 / (TEMPERATURENOMINAL + 273.15);   // + (1/To)
    steinhart = 1.0 / steinhart;                        // Invert
    temperature = steinhart - 273.15;                              // convert to C

    return temperature;
}



void task1(void)
{
    andrijinkriz1=!andrijinkriz1;
    andrijinkriz2=!andrijinkriz1;
}


float step_brzina = 0.002;

int numstep = 512 ;

int main()
{
    Projekt rasvjeta (D9,D8,D2,A3);
    while (1) {
        if(buttondown==0 && !motor.isRunning()) {
            ticki.attach(&task1,0.5);
            motor.step(numstep/4,0,step_brzina);


        }
        if(buttonup==0 && !motor.isRunning()) {

            motor.step(numstep/4,1,step_brzina);
            ticki.detach();
            andrijinkriz1=0;
            andrijinkriz2=0;

        }

        float value0,value1,value2,value3;

        value0 = in0;
        value1 = in1;
        value2 = in2;
        value3 = in3;


        if(value0==1) {
            lcd.cls();
            lcd.printf("OPREZ SKLISKA   CESTA\n");
        }
        if(value1==1) {
            lcd.cls();
            lcd.printf("NESRECA USPORITE\n");
        }
        if(value2==1) {
            lcd.cls();
            lcd.printf("DRZITE RAZMAK   KEEP DISTANCE \n");

        }
        if(value3==1) {
            lcd.cls();
            lcd.printf("RADOVI NA CESTI \n");

        }
        if(value0==0&&value1==0&&value2==0&&value3==0) {
            lcd.cls();

            lcd.printf(" %.1f *C",get_temperature());
        }


    }

}
