/*
 * UDPBroadcastSocket accept socket option flags parameter on bind or init
 * usage 
 *    mySocket.init(SO_BROADCAST); (not tested)
 *   or mySocket.bind(port,SO_BROADCAST); {tested, ok)

 * UDPBroadcastSocket accept socket option flags
 * These option flags per-socket from lwip\core\include\lwip\sockets.h
 */
//#define  SO_DEBUG       0x0001 /* Unimplemented: turn on debugging info recording */
//#define  SO_ACCEPTCONN  0x0002 /* socket has had listen() */
//#define  SO_REUSEADDR   0x0004 /* Allow local address reuse */
//#define  SO_KEEPALIVE   0x0008 /* keep connections alive */
//#define  SO_DONTROUTE   0x0010 /* Unimplemented: just use interface addresses */
//#define  SO_BROADCAST   0x0020 /* permit to send and to receive broadcast messages (see IP_SOF_BROADCAST option) */
//#define  SO_USELOOPBACK 0x0040 /* Unimplemented: bypass hardware when possible */
//#define  SO_LINGER      0x0080 /* linger on close if data present */
//#define  SO_OOBINLINE   0x0100 /* Unimplemented: leave received OOB data in line */
//#define  SO_REUSEPORT   0x0200 /* Unimplemented: allow local address & port reuse */

#include "udpBroadcastSocket.h"
#include "Socket/UDPSocket.h"

#include <cstring>

using std::memset;

int UDPBroadcastSocket::init(int optionFlags) {
    int option = 1;
    if (init_socket(SOCK_DGRAM)<0)
        return -1;
    else
        return lwip_setsockopt(_sock_fd,SOL_SOCKET,optionFlags,(char*)&option,sizeof(option));
}

int UDPBroadcastSocket::bind(int port,int optionFlags)
{
    int option = 1;
    if (UDPSocket::bind(port)<0)
        return -1;
    else
        return lwip_setsockopt(_sock_fd,SOL_SOCKET,optionFlags,(char*)&option,sizeof(option));
}