#ifndef UDPBROADCASTSOCKET_H
#define UDPBROADCASTSOCKET_H

#include "Socket/UDPSocket.h"
#include <cstdint>

/**
UDP Broadcast Socket
    // Allows one-to-many communication over ethernet
    // Override an UDP Socket with additional flag
    // when initing or binding a port use init(SO_BROADCAST) or bind(port,SO_BROADCAST) respectively.
    // Note multicasting many be more suitable for some applications, but isn't support by this socket.
*/
class UDPBroadcastSocket : public UDPSocket {

public:
    int init(int optionFlags); 
    int bind(int port,int optionFlags);
};
#endif