/*************************************************************
 * Specifies the message format from controller to sub
 *************************************************************/
 #ifndef __MSG_H__
 #define __MSG_H__
 
 
typedef struct MSG_FORMAT_T {
        unsigned char cmd;
        unsigned char data[6];
        } MSG_FORMAT;
        
#define MODE_WRITE     = 0x0a;
#define MODE_READ      = 0x05;
#define MODE_PWM       = 0xa0;  // device type uses PWM for control (ie motor control)
#define MODE_ON_OFF    = 0x50;  // device type uses on or off for control (ie camera)
        
#define CMD_INIT    0x00
#define CMD_ROV     0x01
#define CMD_AUX     0x02
#define CMD_STATS   0x04
#define CMD_V    0x08
#define CMD_CLAW    0x40
#define CMD_PTZ     0x80
#define CMD_IMU     0x81

#define HIGH_BYTE(x) ( (x >> 8) & 255)
#define LOW_BYTE(x)  ( (x     ) & 255)
#define ROV_SET_SPEED(data, speed) {data[0]=HIGH_BYTE(speed);data[1]=LOW_BYTE(speed);}
#define ROV_GET_SPEED(data)         ( ((data[0]&0xff)<<8) + (data[1]&0xff) )

// defines the values for various messages
// Motor control
#define ROV_SPEED_POS           0
#define ROV_TURN_POS            2
#define ROV_VERT_POS            4

// Camera
#define CAM_FN_ENABLE           0x80
#define CAM_FN_ZOOM_IN          0x01
#define CAM_FN_ZOOM_OUT         0x02
#define CAM_FN_PAN_LEFT         0x01
#define CAM_FN_PAN_RIGHT        0x02
#define CAM_FN_TILT_UP          0x01
#define CAM_FN_TILT_DOWN        0x02

// Aux_fn messages
#define AUX_FN_KILL_CMD         0xDE
#define AUX_RESTART_CMD         0x55
#define AUX_FN_LIGHT1_ON        0x0a
#define AUX_FN_LIGHT2_ON        0x50
#define AUX_FN_CAM1_ON          0x08
#define AUX_FN_CAM2_ON          0x80
#define AUX_FN_AIR_SOL_ON       0x80
#define AUX_FN_WATER_SOL_ON     0x08

#define AUX_CMD_POS         1
#define AUX_LIGHT_POS       2
#define AUX_CAM_POS         3
#define AUX_SOLENOID_POS    4

// STATS messages
#define STATS_COMPASS_POS     1
#define STATS_PRESSURE_POS    2
#define STATS_X_ACCEL_POS     3
#define STATS_Y_ACCEL_POS     4
#define STATS_Z_ACCEL_POS     5
#define STATS_TEMPERATURE_POS 6
#define STATS_MISC_POS        7

#define STATS_LEAK_DETECTED     0x80
#define STATS_MOTOR_ERROR       0x40
#define STATS_1                 0x20
#define STATS_2                 0x10


// Claw


// States

// IMU (inertial mgmt unit)
#define IMU_PRESSURE_POS        0
#define IMU_COMPASS             2
#define IMU_ACCELEROMETER       4


#endif // indef __MSG_H__

// end of file