/* ROV communication class
 */
#ifndef ROVCOMMS_H
#define ROVCOMMS_H
#include "mbed.h"
#include "msg.h"

#include "EthernetNetIf.h"
#include "UDPSocket.h"

#define STATIC_IP_ADDR

#define MAX_BUFFER_SIZE 10 // max chars in the data stream

#define ipGateway   IpAddr(10,0,0,1)
#define ipMask      IpAddr(255,255,255,0)
#define ipDns       IpAddr(10,0,0,1)

#define RX_TCP_LISTENING_PORT      0xdead // 57005

// last digit for the IP address, defining below 100 for below water
// and above 100 for above water :)
// The host/server is the ROV, so the handset can send info to the host
#define ROV_ADDR        50  // ROV as host and below 100 for below water
#define IPCAMERA_ADDR   60
#define SURFACE_PC_ADDR 102
#define HANDSET_ADDR    101

class RovComms
{
 public:
    RovComms(int addr);
    void InitUDP(int addr);
    
    void CloseSocket(UDPSocket *s, int *state);
    
    void CallbackFn(  void (*function)(void) ) { _callback.attach(function); }
    
    void onUDPSocketEvent(UDPSocketEvent e);
    void Transmit(int pktType);
    char *Receive(void);
    
    void RovPropulsion(int speed, int turn, int vert);
    int RovSpeed() { return iRovSpeed;}
    int RovTurn()  { return iRovTurn;}
    int RovVert()  { return iRovVert;}
    
    void FrontLights(int state);
    int  FrontLights() { return ( (iLight & AUX_FN_LIGHT1_ON)==AUX_FN_LIGHT1_ON?1:0); }
    void RearLights(int state);
    int  RearLights() { return ( (iLight & AUX_FN_LIGHT2_ON)==AUX_FN_LIGHT2_ON?1:0); }
    
    void Camera(int cam);
    int  Camera();

private:
    void Debug(const char *format, ...);
    void ClearBuffer(char *buf) {int i=MAX_BUFFER_SIZE;while (i>0) buf[i--]=0;}
    void ResetValues();

private:
    EthernetNetIf *eth;
    UDPSocket *UdpSkt;
    IpAddr rovAddr;
    Host server;
    
   enum NETWORK_STATE { INIT, OPEN, LISTEN, CONNECTED, ERROR, CLOSED };
   int RxNetworkState;
   int TxNetworkState;
     
   char iRxData[MAX_BUFFER_SIZE];
   char iTxData[MAX_BUFFER_SIZE];
   int iState;
   
   FunctionPointer _callback; // used to call back into code when data arrives

   // ROV params
   int iRovSpeed;
   int iRovTurn;
   int iRovVert;
   
   int iLight;
   int iWaterSol;
   int iAirSol;
   int iCamera;
   int iPressure;
   int iCompass;
   int iAccelX;
   int iAccelY;
   int iAccelZ;

 }; // end class RovComms

#endif // ROVCOMMS_H