/***************************************************
  This is our GFX example for the Adafruit ILI9341 Breakout and Shield
  ----> http://www.adafruit.com/products/1651
  Check out the links above for our tutorials and wiring diagrams
  These displays use SPI to communicate, 4 or 5 pins are required to
  interface (RST is optional)
  Adafruit invests time and resources providing this open source code,
  please support Adafruit and open-source hardware by purchasing
  products from Adafruit!
  Written by Limor Fried/Ladyada for Adafruit Industries.
  MIT license, all text above must be included in any redistribution
 ****************************************************/
 /*
    Ported to mbed by James Kidd
 */

#include "mbed.h"
#include "Adafruit_ILI9341.h"
// Change to your dc/cs/rst pins
Adafruit_ILI9341 tft = Adafruit_ILI9341(D10,D9,D8);

Serial pc(SERIAL_TX,SERIAL_RX);

Timer t;

int min(int x, int y) {
    if(x > y)
        return y;
    return x;
}

int testFillScreen() {
      tft.fillScreen(ILI9341_BLACK);
      tft.fillScreen(ILI9341_RED);
      tft.fillScreen(ILI9341_GREEN);
      tft.fillScreen(ILI9341_BLUE);
      tft.fillScreen(ILI9341_BLACK);
      return 1;
    }

    int testText() {
      tft.fillScreen(ILI9341_BLACK);
      unsigned long start = t.read_ms();
      tft.setCursor(0, 0);
      tft.setTextColor(ILI9341_WHITE);  tft.setTextSize(1);
      tft.print("Hello World!");
      tft.setTextColor(ILI9341_YELLOW); tft.setTextSize(2);
      tft.print(1234.56);
      tft.setTextColor(ILI9341_RED);    tft.setTextSize(3);
      tft.print(0xDEADBEEF, 16);
      tft.println();
      tft.setTextColor(ILI9341_GREEN);
      tft.setTextSize(5);
      tft.print("Groop");
      tft.setTextSize(2);
      tft.print("I implore thee,");
      tft.setTextSize(1);
      tft.print("my foonting turlingdromes.");
      tft.print("And hooptiously drangle me");
      tft.print("with crinkly bindlewurdles,");
      tft.print("Or I will rend thee");
      tft.print("in the gobberwarts");
      tft.print("with my blurglecruncheon,");
      tft.print("see if I don't!");
      return t.read_ms() - start;
    }

    int testLines(uint16_t color) {
      unsigned long start, tt;
      int           x1, y1, x2, y2,
                    w = tft.width(),
                    h = tft.height();

      tft.fillScreen(ILI9341_BLACK);

      x1 = y1 = 0;
      y2    = h - 1;
      start = t.read_ms();
      for(x2=0; x2<w; x2+=6) tft.drawLine(x1, y1, x2, y2, color);
      x2    = w - 1;
      for(y2=0; y2<h; y2+=6) tft.drawLine(x1, y1, x2, y2, color);
      tt     = 1; // fillScreen doesn't count against timing

      tft.fillScreen(ILI9341_BLACK);

      x1    = w - 1;
      y1    = 0;
      y2    = h - 1;
      start = 1;
      for(x2=0; x2<w; x2+=6) tft.drawLine(x1, y1, x2, y2, color);
      x2    = 0;
      for(y2=0; y2<h; y2+=6) tft.drawLine(x1, y1, x2, y2, color);
      tt    += 1;

      tft.fillScreen(ILI9341_BLACK);

      x1    = 0;
      y1    = h - 1;
      y2    = 0;
      start = 1;
      for(x2=0; x2<w; x2+=6) tft.drawLine(x1, y1, x2, y2, color);
      x2    = w - 1;
      for(y2=0; y2<h; y2+=6) tft.drawLine(x1, y1, x2, y2, color);
      tt    += 1;

      tft.fillScreen(ILI9341_BLACK);

      x1    = w - 1;
      y1    = h - 1;
      y2    = 0;
      start = 1;
      for(x2=0; x2<w; x2+=6) tft.drawLine(x1, y1, x2, y2, color);
      x2    = 0;
      for(y2=0; y2<h; y2+=6) tft.drawLine(x1, y1, x2, y2, color);

      return t.read_ms() - start;
    }

    int testFastLines(uint16_t color1, uint16_t color2) {
      unsigned long start;
      int           x, y, w = tft.width(), h = tft.height();

      tft.fillScreen(ILI9341_BLACK);
      start = t.read_ms();
      for(y=0; y<h; y+=5) tft.drawFastHLine(0, y, w, color1);
      for(x=0; x<w; x+=5) tft.drawFastVLine(x, 0, h, color2);

      return t.read_ms() - start;
    }

    int testRects(uint16_t color) {
      unsigned long start;
      int           n, i, i2,
                    cx = tft.width()  / 2,
                    cy = tft.height() / 2;

      tft.fillScreen(ILI9341_BLACK);
      n     = min(tft.width(), tft.height());
      start = t.read_ms();
      for(i=2; i<n; i+=6) {
        i2 = i / 2;
        tft.drawRect(cx-i2, cy-i2, i, i, color);
      }

      return t.read_ms() - start;
    }

    int testFilledRects(uint16_t color1, uint16_t color2) {
      unsigned long start, tt = 0;
      int           n, i, i2,
                    cx = tft.width()  / 2 - 1,
                    cy = tft.height() / 2 - 1;

      tft.fillScreen(ILI9341_BLACK);
      n = min(tft.width(), tft.height());
      start = t.read_ms();
      for(i=n; i>0; i-=6) {
        i2    = i / 2;
        start = 1;
        tft.fillRect(cx-i2, cy-i2, i, i, color1);
        tt    += 1;
        // Outlines are not included in timing results
        tft.drawRect(cx-i2, cy-i2, i, i, color2);
      }

      return t.read_ms() - start;
    }

    int testFilledCircles(uint8_t radius, uint16_t color) {
      unsigned long start;
      int x, y, w = tft.width(), h = tft.height(), r2 = radius * 2;

      tft.fillScreen(ILI9341_BLACK);
      start = t.read_ms();
      for(x=radius; x<w; x+=r2) {
        for(y=radius; y<h; y+=r2) {
          tft.fillCircle(x, y, radius, color);
        }
      }

      return t.read_ms() - start;
    }

    int testCircles(uint8_t radius, uint16_t color) {
      unsigned long start;
      int           x, y, r2 = radius * 2,
                    w = tft.width()  + radius,
                    h = tft.height() + radius;

      // Screen is not cleared for this one -- this is
      // intentional and does not affect the reported time.
      start = t.read_ms();
      for(x=0; x<w; x+=r2) {
        for(y=0; y<h; y+=r2) {
          tft.drawCircle(x, y, radius, color);
        }
      }

      return t.read_ms() - start;
    }

    int testTriangles() {
      unsigned long start;
      int           n, i, cx = tft.width()  / 2 - 1,
                          cy = tft.height() / 2 - 1;

      tft.fillScreen(ILI9341_BLACK);
      n     = min(cx, cy);
      start = t.read_ms();
      for(i=0; i<n; i+=5) {
        tft.drawTriangle(
          cx    , cy - i, // peak
          cx - i, cy + i, // bottom left
          cx + i, cy + i, // bottom right
          tft.color565(0, 0, i));
      }

      return t.read_ms() - start;
    }

    int testFilledTriangles() {
      unsigned long start, tt = 0;
      int           i, cx = tft.width()  / 2 - 1,
                       cy = tft.height() / 2 - 1;

      tft.fillScreen(ILI9341_BLACK);
      start = t.read_ms();
      for(i=min(cx,cy); i>10; i-=5) {
        start = 1;
        tft.fillTriangle(cx, cy - i, cx - i, cy + i, cx + i, cy + i,
          tft.color565(0, i, i));
        tt += 1;
        tft.drawTriangle(cx, cy - i, cx - i, cy + i, cx + i, cy + i,
          tft.color565(i, i, 0));
      }

      return t.read_ms() - start;
    }

    int testRoundRects() {
      unsigned long start;
      int           w, i, i2,
                    cx = tft.width()  / 2 - 1,
                    cy = tft.height() / 2 - 1;

      tft.fillScreen(ILI9341_BLACK);
      w     = min(tft.width(), tft.height());
      start = t.read_ms();
      for(i=0; i<w; i+=6) {
        i2 = i / 2;
        tft.drawRoundRect(cx-i2, cy-i2, i, i, i/8, tft.color565(i, 0, 0));
      }

      return t.read_ms() - start;
    }



    int testFilledRoundRects() {
      unsigned long start;
      int           i, i2,
                    cx = tft.width()  / 2 - 1,
                    cy = tft.height() / 2 - 1;

      tft.fillScreen(ILI9341_BLACK);
      start = t.read_ms();

      for(i=min(tft.width(), tft.height()); i>20; i-=6) {
        i2 = i / 2;
        tft.fillRoundRect(cx-i2, cy-i2, i, i, i/8, tft.color565(0, i, 0));
      }

      return t.read_ms() - start;
    }


int main() {
    tft.begin();
    t.start();
    
    while(1) {
          pc.printf("Ili9341 test\n");
          uint8_t x = tft.readcommand8(ILI9341_RDMODE);
          pc.printf("Display Power Mode: 0x"); pc.printf("%d\n",x);
          x = tft.readcommand8(ILI9341_RDMADCTL);
          pc.printf("MADCTL Mode: 0x"); pc.printf("%d\n",x);
          x = tft.readcommand8(ILI9341_RDPIXFMT);
          pc.printf("Pixel Format: 0x"); pc.printf("%d\n",x);
          x = tft.readcommand8(ILI9341_RDIMGFMT);
          pc.printf("Image Format: 0x"); pc.printf("%d\n",x);
          x = tft.readcommand8(ILI9341_RDSELFDIAG);
          pc.printf("Self Diagnostic: 0x"); pc.printf("%d\n",x);

          pc.printf(("Benchmark                Time (microseconds)\n"));

          pc.printf(("Screen fill              "));
          pc.printf("%d",testFillScreen());
          wait_ms(500);

          pc.printf(("Text                     "));
          pc.printf("%d\n",testText());
          wait_ms(3000);

          pc.printf(("Lines                    "));
          pc.printf("%d\n",testLines(ILI9341_CYAN));
          wait_ms(500);

          pc.printf(("Horiz/Vert Lines         "));
          pc.printf("%d\n",testFastLines(ILI9341_RED, ILI9341_BLUE));
          wait_ms(500);

          pc.printf(("Rectangles (outline)     "));
          pc.printf("%d\n",testRects(ILI9341_GREEN));
          wait_ms(500);

          pc.printf(("Rectangles (filled)      "));
          pc.printf("%d\n",testFilledRects(ILI9341_YELLOW, ILI9341_MAGENTA));
          wait_ms(500);

          pc.printf(("Circles (filled)         "));
          pc.printf("%d\n",testFilledCircles(10, ILI9341_MAGENTA));

          pc.printf(("Circles (outline)        "));
          pc.printf("%d\n",testCircles(10, ILI9341_WHITE));
          wait_ms(500);

          pc.printf(("Triangles (outline)      "));
          pc.printf("%d\n",testTriangles());
          wait_ms(500);

          pc.printf(("Triangles (filled)       "));
          pc.printf("%d\n",testFilledTriangles());
          wait_ms(500);
          tft.fillScreen(ILI9341_WHITE);
          pc.printf(("Rounded rects (outline)  "));
          pc.printf("%d\n",testRoundRects());
          wait_ms(500);

          pc.printf(("Rounded rects (filled)   "));
          pc.printf("%d\n",testFilledRoundRects());
          wait_ms(500);

          pc.printf(("Done!"));
    }
}
