#include "mbed.h"
#include "EthernetInterface.h"

Serial pc(USBTX, USBRX);
EthernetInterface eth;

void
s2c_run(TCPSocket *sock)
{
    int ret;
    char c;
    while (true) {
        ret = sock->recv(&c, 1);
        if (ret == 1) {
            printf("recv %02x=%c\r\n", c, (0x20 <= c && c < 0x7f) ? c : '?');
        } else if (ret == 0) {
            printf("EOS\r\n");
        } else {
            error("recv: %d\r\n", ret);
        }
    }
}

int main(void)
{
    Thread s2c;
    int err;

    printf("\r\n== sendrecv ==\r\n");
    err = eth.connect();
    if (err) error("connect: %d\n", err);
    printf("ip %s\r\n", eth.get_ip_address());
    TCPServer srv;
    err = srv.open(&eth);
    if (err) error("open: %d\r\n", err);
    err = srv.bind(8084);
    if (err) error("bind: %d\r\n", err);
    err = srv.listen(1);
    if (err) error("listen: %d\r\n", err);
    TCPSocket sock;
    err = srv.accept(&sock);
    if (err) error("accept: %d\r\n", err);
    printf("accepted connection\r\n");
    s2c.start(Callback<void()>(&sock, s2c_run));
    while (true) {
        printf("tick...\r\n");
        err = sock.send("tick\n", 5);
        if (err <= 0) error("send: %d\r\n", err);
        printf("...sent\r\n");
        wait(1.0);
    }
}
