#include "mbed.h"
#include "SDFileSystem.h"

SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS
Serial pc(USBTX, USBRX);
FILE *fp;

uint32_t do_list(const char *fsrc)
{
    DIR *d = opendir(fsrc);
    struct dirent *p;
    uint32_t counter = 0;

    while ((p = readdir(d)) != NULL) {
        counter++;
        printf("%s\n", p->d_name);
    }
    closedir(d);
    return counter;
}

// bool is_folder(const char *fdir)
// {
//     DIR *dir = opendir(fdir);
//     if (dir) {
//         closedir(dir);
//     }
//     return (dir != NULL);

// }

// bool is_file(const char *ffile)
// {
//     FILE *fp = fopen(ffile, "r");
//     if (fp) {
//         fclose(fp);
//     }
//     return (fp != NULL);
// }

int main()
{
    pc.printf("Initializing \n");
    wait(2);

    printf("disk_status: %d\n", sd.disk_status());
    printf("card_present: %d\n", sd.card_present());
    printf("card_type: %d\n", (int)sd.card_type());
    
    printf("\nList /\n");
    do_list("/");
    
    printf("\nList /sd\n");
    do_list("/sd");
    printf("\nEnd\n");
}
