//=======================================================================
//      Demonstrate memory leak in k64f ethernet driver
//=======================================================================
#include "mbed.h"
#include "EthernetInterface.h"
#include "lwip/stats.h"

// Configuration
#define DEST_IP "192.168.3.1"           // Where to send UDP packets
#define DEST_PORT 4009
#define NBIG 8                         // How many big packets in burst
#define NSMALL 12                       // How many small packets in burst

EthernetInterface eth;
SocketAddress dest;
UDPSocket sock;
char data[1400] = {0};

// Send a burst of COUNT packets, each of SIZE bytes
// Return number sent before memory error
int burst(int count, size_t size) {
    int num;
    for (num = 0; num < count; num++) {
        int err = sock.sendto(dest, data, size);
        if (err == NSAPI_ERROR_NO_MEMORY) {
            break;
        } else if (err < 0) {
            printf("sendto(%u): %d\n", size, err);
            break;
        }
        data[0] ++;
    }
    return num;
}

int main() {
    printf("k64f-net-leak\n");
    int err = eth.connect();
    if (err < 0) {
        printf("eth.connect: %d\n", err);
        return 1;
    }

    err = sock.open(&eth);
    if (err < 0) {
        printf("sock.open: %d\n", err);
        return 1;
    }

    dest = SocketAddress(DEST_IP, DEST_PORT);

#if PRIME_ARP
    // First packet is slightly special, since ARP request needed first
    burst(1, 10);
#endif

    //wait_ms(20);

    while (1) {
        // If enabled by macros in mbed_app.json, show lwip memory usage
        MEM_STATS_DISPLAY();

        // Stuff some big packets into the ring buffer
        int big = burst(NBIG, 1400);
        // See if we can overwrite them
        int small = burst(NSMALL, 20);
        printf("big=%d small=%d\n", big, small);
        wait(1.0);
    }
}
