// Demonstrate that only a single gpio_irq_handler may be used,
// rather than per pin or per port.
// On K64F, SW2=PTC6 and SW3=PTA4 i.e. on different ports.
#include "mbed.h"

volatile int count2 = 0;
volatile int count3 = 0;

void handler2(uint32_t id, gpio_irq_event event) {
    ++ count2;
}

void handler3(uint32_t id, gpio_irq_event event) {
    ++ count3;
}
    
int main() {
    gpio_t sw2;
    gpio_t sw3;
    gpio_irq_t irq2;
    gpio_irq_t irq3;
    
    // Set up switches as inputs (enables port clocking)
    gpio_init_in(&sw2, SW2);
    gpio_irq_init(&irq2, SW2, handler2, 1);
    gpio_irq_set(&irq2, IRQ_FALL, 1);

    gpio_init_in(&sw3, SW3);
    gpio_irq_init(&irq3, SW3, handler3, 1); // mbed now forgets handler2
    gpio_irq_set(&irq3, IRQ_FALL, 1);

    while (1) {
        printf("Press SW2 and SW3 once each...\r\n");
        wait(10);
        // Each count should be 1, no?
        printf("SW2 count=%d, SW3 count=%d\r\n", count2, count3);
    }
}
    