#include <mbed.h>
#include <EthernetInterface.h>

struct TestAddr {
    const char *host;
    unsigned port;
};

#define GOOD_HOST "192.168.3.1"
#define BAD_HOST "192.168.3.2"
#define BAD_NET "239.9.9.9" // Multicast

const TestAddr test_addrs[] = {
    {GOOD_HOST, 2}, // port 2 not open; get ECONNREFUSED on Linux
    {BAD_HOST, 80}, // get EHOSTUNREACH on Linux
    {BAD_NET, 99}, // get ENETUNREACH on Linux
};

EthernetInterface eth;

int main() {
    printf("connect-test\r\n");

    int err = eth.connect();
    if (err) error("eth.connect: %d\r\n", err);
    printf("IP address %s\r\n", eth.get_ip_address());
    
    for (int i = 0; i < sizeof(test_addrs)/sizeof(test_addrs[0]); i++) {
        const TestAddr *addr = &test_addrs[i];
        TCPSocket sock;
        err = sock.open(&eth);
        if (err) error("sock.open: %d\r\n", err);
        printf("Connecting to %s:%u\r\n", addr->host, addr->port);
        err = sock.connect(addr->host, addr->port);
        printf("err = %d\r\n", err);
        sock.close();
    }
    printf("All done\r\n");
    return 0;
}