#include "mbed.h"
#include "mbipanel.h"

using namespace mbipanel;
using namespace mbipanel::hardware;

DigitalOut led(LED1);

class SerialDisplay {
public:
    SerialDisplay(Serial& com) {
        com_ = &com;
        // Set up large board.
        mbicfg_ = new MBI(1, 4, mbipanel::MBI5030, cfg::pixelcfg_large1x4);
        panelcfg_ = new Panel(8, 2, *mbicfg_);
        gridcfg_ = new PanelGrid(1, 1, *panelcfg_);

        PinName pincfg[4] = {p18, p19, p20, p21};
        display_ = new Display(*gridcfg_, pincfg);
        display_->configure_12bit();
    }

    ~SerialDisplay() {
        delete display_;
        delete mbicfg_;
        delete panelcfg_;
        delete gridcfg_;
    }

    void start() {
        // Wait for any token to arrive to signal the start of communication.
        while (!com_->readable()) { }
        com_.printf("Hello. Starting...\n");
        command_loop();
    }

private:
    // Respond to commands arriving over the serial port.
    void command_loop() {
        while (true) {
            if (com_->readable()) {
                // LED turns on while a command is being interpreted.
                led = !led;
                char c = com_->getc();
                if (c == 'p') {
                    // Set pixel.
                    // Format: px[int]y[int]r[int]g[int]b[int]w[int]
                    int x, y, r, g, b, w;
                    com_.scanf("x%dy%dr%dg%db%dw%d", &x, &y, &r, &g, &b, &w);
                    display_->set(x, y, r, g, b, w);
                } else if (c == '+') {
                    // Draw display.
                    // Format: +
                    display_->draw();
                    com_.printf("Drawing!");
                } else if (c == '-') {
                    // Clear display.
                    // Format: -
                    display_->reset();
                    com_.printf("Resetting!");
                }
                led = !led;
            }
        }
    }

    Serial* com_;
    Display* display_;
    MBI* mbicfg_;
    Panel* panelcfg_;
    PanelGrid* gridcfg_;
};

int main() {
    Serial com(p9, p10);
    com.baud(115200);
    SerialDisplay display(com);
    display.start();
}