/* mbed Microcontroller Library
 * Copyright (c) 2006-2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "ble/BLE.h"
#include "ble/DiscoveredCharacteristic.h"
#include "ble/DiscoveredService.h"
BLE        ble;
DigitalOut led1(LED1);
Serial pc(USBTX, USBRX);

/* Declare the array */

static const unsigned NUM_LIST = 3;
static const unsigned ADDR_LEN = 6;

/* Declare the pointer */

int8_t temp;
uint8_t pt_addr = 0;
uint8_t list_addr[NUM_LIST][ADDR_LEN]={0,0,0,0,0,0, 0,0,0,0,0,0, 0,0,0,0,0,0};
int8_t list_rssi[NUM_LIST];

void periodicCallback(void)
{
    led1 = !led1; /* Do blinky on LED1 while we're waiting for BLE events */
}

void advertisementCallback(const Gap::AdvertisementCallbackParams_t *params) {
    unsigned i;
           
    for(i = 0; i < NUM_LIST; i++) 
    {
        if(list_addr[i][5] == params->peerAddr[5] && list_addr[i][4] == params->peerAddr[4] && list_addr[i][3] == params->peerAddr[3] && list_addr[i][2] == params->peerAddr[2] && list_addr[i][1] == params->peerAddr[1] && list_addr[i][0] == params->peerAddr[0]) 
        {          
            /* Only RSSI Value update */
            list_rssi[i] = params->rssi;
            //pc.printf("%dth RSSI Update!\r\n",i+1);
            break;
        }
        if(list_addr[i][5] == 0 && list_addr[i][4] == 0 && list_addr[i][3] == 0 && list_addr[i][2] == 0 && list_addr[i][1] == 0 && list_addr[i][0] == 0) 
        {
            pc.printf("Adv peerAddr: [%02x %02x %02x %02x %02x %02x] rssi %d, ScanResp: %u, AdvType: %u\r\n",
           params->peerAddr[5], params->peerAddr[4], params->peerAddr[3], params->peerAddr[2], params->peerAddr[1], params->peerAddr[0],
           params->rssi, params->isScanResponse, params->type);
            /* Save the address */
            list_addr[i][5] = params->peerAddr[5];
            list_addr[i][4] = params->peerAddr[4];
            list_addr[i][3] = params->peerAddr[3];
            list_addr[i][2] = params->peerAddr[2];
            list_addr[i][1] = params->peerAddr[1];
            list_addr[i][0] = params->peerAddr[0];
            /* Save RSSI value */
            list_rssi[i] = params->rssi;
            pc.printf("Address & RSSI Save!\r\n");
            if ( i==NUM_LIST-1 ) 
            {
                pc.printf("Find Maximum value!\r\n");
                /* Find Maximum RSSI value */
                for(unsigned j=0;j<NUM_LIST;j++) 
                {
                    for(unsigned k=j ; k<NUM_LIST ; k++) 
                    {
                        if(list_rssi[j] < list_rssi[k]) 
                        {
                            /* Swap RSSI Value */
                            temp = list_rssi[j];
                            list_rssi[j] = list_rssi[k];
                            list_rssi[k] = temp;
                            
                            /* Swap the address */
                            for(unsigned l = 0; l < 6 ; l++) 
                            {
                                temp = list_addr[j][l];
                                list_addr[j][l] = list_addr[k][l];
                                list_addr[k][l] = temp;
                            }
                        }
                    }
                }
                for(unsigned j=0; j<NUM_LIST ; j++)
                    pc.printf("Address %d : %02x %02x %02x %02x %02x %02x RSSI : %d\r\n", j, list_addr[j][5], list_addr[j][4], list_addr[j][3], list_addr[j][2], list_addr[j][1], list_addr[j][0], list_rssi[j]);                        
            }
            break;
        }
    }
    if( i == NUM_LIST-1)
    {
        ble.gap().stopScan();
        ble.gap().connect(list_addr[0], Gap::ADDR_TYPE_RANDOM_STATIC, NULL, NULL);
    }
}

void serviceDiscoveryCallback(const DiscoveredService *service) {
    if (service->getUUID().shortOrLong() == UUID::UUID_TYPE_SHORT) {
        pc.printf("S UUID-%x attrs[%u %u]\r\n", service->getUUID().getShortUUID(), service->getStartHandle(), service->getEndHandle());
    } else {
        printf("S UUID-");
        const uint8_t *longUUIDBytes = service->getUUID().getBaseUUID();
        for (unsigned i = 0; i < UUID::LENGTH_OF_LONG_UUID; i++) {
            printf("%02x", longUUIDBytes[i]);
        }
        pc.printf(" attrs[%u %u]\r\n", service->getStartHandle(), service->getEndHandle());
    }
}
 
void characteristicDiscoveryCallback(const DiscoveredCharacteristic *characteristicP) {
 
}
 
void discoveryTerminationCallback(Gap::Handle_t connectionHandle) {
    pc.printf("terminated SD for handle %u\r\n", connectionHandle);
}
 
void connectionCallback(const Gap::ConnectionCallbackParams_t *params) {
    pc.printf("Connection success to %02x %02x %02x %02x %02x %02x\r\n", list_addr[0][5], list_addr[0][4], list_addr[0][3], list_addr[0][2], list_addr[0][1], list_addr[0][0]);
    ble.stopAdvertising();
    wait(1);
    if (params->role == Gap::CENTRAL) {
        ble.gattClient().onServiceDiscoveryTermination(discoveryTerminationCallback);
        ble.gattClient().launchServiceDiscovery(params->handle, serviceDiscoveryCallback, characteristicDiscoveryCallback, 0xa000, 0xa001);
    }
    ble.gap().disconnect(0,Gap::REMOTE_USER_TERMINATED_CONNECTION);
}
void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    /* Initialize address list */
    for(unsigned i=0; i<NUM_LIST ; i++) {
        list_rssi[i] = 0;
        for(unsigned j=0; j<ADDR_LEN ; j++)
            list_addr[i][j] = 0;
    }
    pc.printf("Disconnected\r\n");
    pc.printf("Rescan\r\n");
    ble.startScan(advertisementCallback);
}
    

int main(void)
{
    led1 = 1;
    Ticker ticker;
    ticker.attach(periodicCallback, 1);
    ble.onConnection(connectionCallback);
    ble.onDisconnection(disconnectionCallback);

    ble.init();
    
    pc.baud(9600);
    pc.printf("Observer Init \r\n");


    /* */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                    (const uint8_t *)"DDUDDU", sizeof("DDUDDU") - 1);
   
    /* We don't need any advertising because of its role */
    //ble.gap().setAdvertisingInterval(100); /* 1second. */
    //ble.gap().startAdvertising();

    ble.gap().setScanParams(500 /* scan interval */, 500 /* scan window */);
    ble.gap().startScan(advertisementCallback);
    
    while (true) {
        ble.waitForEvent();
    }
}
