#include "mbed.h"
#include "platform/mbed_thread.h"
#include "HCSR04.h"

int readDistance; // This variable stores the the distance read from HCSR04
char sonarData; // This is the data to be sent through UART to S32K144

char Data_Read;
Serial UARTComm(D1,D0); // Intializing UART Tx, Rx 


int main()
{
    HCSR04 Sonar(D3, D2); // Initializing an object "Sonar" and setting the Trigger Pin & Echo Pin
    UARTComm.baud(115200); // Initializing Baud Rate
    
    while (true) {
        readDistance = Sonar.distance(1); //Reads the distance in cm
        
        if (readDistance < 30){
            sonarData = 's'; // 's' for stop
        }
        else{
            sonarData = 'r'; // 'r' for run
        }
        
        
        printf("Distance = %d        Case: %c\r\n",readDistance, sonarData);
        UARTComm.putc(sonarData);
        
        //while (UARTComm.readable()){
        Data_Read = UARTComm.putc(UARTComm.getc());//BT.putc(BT.getc());
        int int_dataRead = (int) Data_Read;
        if(int_dataRead==2)
        {printf("Safe Distance.\r\n");}
        else if(int_dataRead==1)
        {printf("Unsafe Distance. Motor is not running.\r\n");}
        
    }
}
