/**
*
*   Code to get data from the camera by connecting to a web server via WiFi (using Adafruit CC3000).
*
*   author: Leo Kam
*
*
*   The code to connect to the web via Adafruit is adapted from the code by Ben Zhang and Antonio Iannopollo, found at 
*   http://developer.mbed.org/users/nebgnahz/code/CC3000_demo/
*   The following libraries are used:
*    - cc3000_hostdriver_mbedsocket
*     (http://developer.mbed.org/users/Kojto/code/cc3000_hostdriver_mbedsocket/)
*    - HTTPClient (http://developer.mbed.org/users/donatien/code/HTTPClient/)
*
**/


#include "mbed.h"
#include "cc3000.h"
#include "HTTPClient.h"

// KL25Z wifi connection
// we need to define connection pins for:
// - IRQ      => (pin D3)
// - Enable   => (pin D5)
// - SPI CS   => (pin D10)
// - SPI MOSI => (pin D11)
// - SPI MISO => (pin D12)
// - SPI CLK  => (pin D13)
// plus wifi network SSID, password, security level and smart-configuration flag.
mbed_cc3000::cc3000 wifi(D3, D5, D10, SPI(D11, D12, D13),
                         "EECS-PSK", "Thequickbrown", WPA2, false);

// create an http instance
HTTPClient http;

// str is used to hold the response data
char str[512];
char * p;

// setup the serial connection, and LEDs
Serial pc(USBTX, USBRX);
DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);

void initializeWiFi() {
    // by default, it's red
    led_red = 0;
    led_green = 1;
    
    //print message to indicate the program has started
    pc.printf("CC3000 Sample Program\r\n");
    wifi.init();
    pc.printf("Wifi Initialized\r\n");
    
    // check connection status
    while(wifi.is_connected() == false) {
        // try to connect
        if (wifi.connect() == -1) {
            pc.printf("Failed to connect."
                      "Please verify connection details and try again.\r\n");
            led_red = 0;
            led_green = 1;
        } else {
            pc.printf("IP address: %s \r\n", wifi.getIPAddress());
            
            //once connected, turn green LED on and red LED off, and exit loop
            led_red = 1;
            led_green = 0;
            break;
        }
    }
}


/* Get the x, y-coordinates and depth from camera. Return true if successfuly retrieve data from server, else return false and do not change parameters. */
bool getCameraData(double &x, double &y, double &z, int timeout=2000) {
    // check connection status
    while(wifi.is_connected() == false) {
        // try to connect
        if (wifi.connect() == -1) {
            pc.printf("Failed to connect."
                      "Please verify connection details and try again.\r\n");
            led_red = 0;
            led_green = 1;
        } else {
            pc.printf("IP address: %s \r\n", wifi.getIPAddress());
            
            //once connected, turn green LED on and red LED off, and exit loop
            led_red = 1;
            led_green = 0;
            break;
        }
    }
    int ret = http.get("https://pew-pew-pew.herokuapp.com/position", str, 512);
    if (!ret) {
        p = strtok(str, " ");
        x = atof(p);
        p = strtok(NULL, " ");
        y = atof(p);
        p = strtok(NULL, " ");
        z = atof(p);
        pc.printf("Camera data: %f %f %f\r\n", x, y, z);
        return true;
    } else {
        /*pc.printf("Error - ret = %d - HTTP return code = %d\r\n",
                  ret,
                  http.getHTTPResponseCode());*/
        return false;
    }
} 
