/*******************************************************************************
ECE 595 2018 Spring
Project 1
Group 10
last Update @ 
memo:   ?????????
        ??????//app????
        ????? for timer
*******************************************************************************/
#include "mbed.h"
#include "DHT.h"
#include "DigitDisplay.h"

DHT sensor(D4, DHT11); 
DigitalOut buzzer(D2);
Timer tOverheat;
DigitalOut ledred(LED_RED);//or LED1 try both
DigitalIn touch(D7);
DigitDisplay display(D5, D6);

Serial bluetooth(PTC15, PTC14); //wireless bluetooth connection to Android Device for output
Serial pc(USBTX,USBRX);

int timeflag = 0;
int timeread = 0;
int on = 1, off = 0; 

void stemp(float FFF){
    uint8_t FF = FFF;
    display.setColon(0);
    display.write(2, FF / 10);
    display.write(3, FF % 10);
    display.write(0, 0);
    display.write(1, 0);
}

void stime(int ootime){
    uint8_t otime = ootime;
    display.setColon(0);
    display.write(2, otime / 10);
    display.write(3, otime % 10);
    display.write(0, 0);
    display.write(1, 0);
}

void sdisplay(int sw, int tm, float tp){
    if(sw==1){
        stime(tm);
        }
    else if(sw==0){
        stemp(tp);
    }
}

void blink(){
     buzzer = on;
     ledred = 1;       
     wait(.3);      
     buzzer = off;
     ledred = 0;
     }

int main() 
{ 
    int error = 0; 
    float h = 0.0f, f = 0.0f;
    ledred = 1;//?????0???1?,??????
    
    pc.baud(9600);
    bluetooth.baud(9600);
    wait(2.0f);
    
    while(1) 
    { 
        error = sensor.readData(); 
        if (0 == error)
        { 
            f = sensor.ReadTemperature(FARENHEIT); 
            h = sensor.ReadHumidity(); 
            sdisplay(touch,timeread,f);
            pc.printf("Temperature in F: %4.2f\n",f);
            pc.printf("Humidity is: %4.2f\n",h); 
            bluetooth.printf("%4.2f %4.2f",f,h);
            if(f>33)
            {      
                if(timeflag==0){
                    timeflag = 1;
                    blink();
                    pc.printf("Over Heat!!\n");
                    tOverheat.start();
                    }
                else if(timeflag==1){
                    timeread = tOverheat.read();
                    if(timeread >= 10){
                        buzzer = on;
                        pc.printf("Game Over\n");
                        ledred = 0;
                        }
                    else{
                        blink();
                        pc.printf("Hurry Up, still have chance\n");
                        }
                 }                      
            }
            else if(f<=33){
                timeflag = 0;
                tOverheat.reset();
                timeread = 0;
                buzzer = off;
                ledred = 1;
            }
        }
        else{
           // pc.printf("Woops, Sensor Error: %d\n", error);
        }
    }   
} 