// Hello World! for the TextLCD
 
#include "mbed.h"
#include "TextLCD.h"
#include "nRF24L01P.h"




//nrf24l01p transiever setup
nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTC4, PTC12); 
//nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTC3,PTC2 , PTA2); //Slave board 
DigitalOut myled1(LED_GREEN);
DigitalOut myled2(LED_RED);
#define TRANSFER_SIZE   4

// Host PC Communication channels
Serial pc(USBTX, USBRX); // tx, rx
//LCD SETUP
// I2C Communication
I2C i2c_lcd(PTE25,PTE24); // SDA, SCL
//I2C Portexpander PCF8574
TextLCD_I2C lcd(&i2c_lcd, 0x7e , TextLCD::LCD16x2, TextLCD::WS0010); // I2C bus, PCF8574 addr, LCD Type, Ctrl Type


//ESP8266 SETUP
Serial esp(D1, D0); // tx, rx
DigitalOut reset(D3);
Timer t;
int  count,ended,timeout;
char buf[1024];
char snd[255];
char ssid[32] = "IU DeviceNet";     // enter WiFi router ssid inside the quotes
char pwd [32] = ""; // enter WiFi router password inside the quotes



void SendCMD(),getreply(),ESPconfig(),ESPsetbaudrate(), ESPconnection(),nrfmodule();



int main() {
    
    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    int txDataCnt = 0;
    int rxDataCnt = 0;

    my_nrf24l01p.powerUp();
    
    lcd.cls();
    lcd.locate(3,0);
    lcd.printf("connecting");
    lcd.locate(3,1);
    lcd.printf("to wifi...");
    
    
// Show cursor as blinking character
    lcd.setCursor(TextLCD::CurOff_BlkOn);
    lcd.setBacklight(TextLCD::LightOn);
    
    
    pc.baud(115200);
    wait(0.5);
    esp.baud(115200);// change this to the new ESP8266 baudrate if it is changed at any time.
      
    nrfmodule();
    ESPconnection();
    
    lcd.cls();
    lcd.locate(3,0);
    lcd.printf("SYSTEM ARMED");
    pc.printf("\nwaiting to be triggered\n");
    
   while(1){
      
              wait(1);
        ////this is for the recieving part of the code  part of the code 
        // If we've received anything in the nRF24L01+...
        
        if ( my_nrf24l01p.readable() ) {
            lcd.cls();
            pc.printf("message recieved\n\r");
            // ...read the data into the receive buffer
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );

            // Display the receive buffer contents via the host serial link
            for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ) {

                pc.putc( rxData[i] );  
                pc.printf("data to recieve\r");
                if(rxData[i]=='w'){
                
                lcd.locate(3,0);   
                lcd.printf ("WARNING!!!");
                lcd.locate(0,1);   
                lcd.printf ("ALARM TRIGGERED");
                }else if(rxData){
                    lcd.locate(3,0);
                    lcd.printf ("SAFE");
                    lcd.locate(3,1);
                    lcd.printf ("SYSTEM ARMED");
                    }
            }

            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            myled2 = !myled2;
        }
       
       
       }
 

     
}

//FUNCTIONS 

void ESPconnection()
{
    pc.printf("\n---------- Get IP and MAC ----------\r\n");
        strcpy(snd, "AT+CIFSR\r\n");
        SendCMD();
        timeout=10;
        getreply();
        pc.printf(buf);
        wait(2);
        
        
    pc.printf("\n---------- Get Connection Status ----------\r\n");
    strcpy(snd, "AT+CIPSTATUS\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);
    lcd.cls();
    lcd.locate(3,0);
    lcd.printf("connected");
    wait(1);
    
    
}


void ESPsetbaudrate()
{
    strcpy(snd, "AT+CIOBAUD=115200\r\n");   // change the numeric value to the required baudrate
    SendCMD();
}


void SendCMD()
{
    esp.printf("%s", snd);
}

void getreply()
{
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;
    count=0;
    while(!ended) {
        if(esp.readable()) {
            buf[count] = esp.getc();
            count++;
        }
        if(t.read() > timeout) {
            ended = 1;
            t.stop();
            t.reset();
        }
    }
}
void nrfmodule(){
    
     // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "nRF24L01 module has been set up" );


    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    
    
    
    }
