#include "mbed.h"
#include "PS_PAD.h"

PS_PAD vsc3(PA_7,PA_6,PA_5,PB_6);

PwmOut s1 (PC_9);
PwmOut s2 (PB_8);
PwmOut s3 (PB_9);

int main()
{

    vsc3.init();

    s1.period_us(20000);
    s2.period_us(20000);
    s3.period_us(20000);

    while(1) {

        vsc3.poll();
        if(vsc3.read(PS_PAD::PAD_TRIANGLE)) {
            s1.pulsewidth_us(300);
        } else if(vsc3.read(PS_PAD::PAD_RIGHT)) {
            s2.pulsewidth_us(500);
        } else if(vsc3.read(PS_PAD::PAD_TOP)) {
            s3.pulsewidth_us(500);
        } else if(vsc3.read(PS_PAD::PAD_X)) {
            s1.pulsewidth_us(2400);
        } else;
        if(vsc3.read(PS_PAD::PAD_LEFT)) {
            s2.pulsewidth_us(2400);
        } else;
        if(vsc3.read(PS_PAD::PAD_BOTTOM)) {
            s3.pulsewidth_us(2400);
        } else;
        wait(0.05);

    }
}