#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "Speaker.h"
#include "PinDetect.h"
#include <iostream>
#include <ctime>


DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

SDFileSystem sd(p5, p6, p7, p8, "sd");
AnalogOut DACout(p18);
Serial pc(USBTX, USBRX);
Serial blue(p28,p27);
wave_player waver(&DACout);
PinDetect  pin(p14);

bool joyPressedBool = false;
bool phonePressedBool = false;
clock_t joyTime;
clock_t phoneTime;
clock_t ticks = CLOCKS_PER_SEC;

 void joyPressed( void ) {
    joyPressedBool = true;
    joyTime = clock();
    //joyTime = (double)joyTime/(double)ticks;
    led2 = 1;
    pc.printf("Player 1 pressed!\n");
    //wait(3);
 }
 
 void joyReleased( void ) {
    joyPressedBool = true;
    joyTime = clock();
    led2 = 0;
    //wait(3);
 }
 
 void joyPressedHeld( void ) {

 }
 
 void joyReleasedHeld( void ) {

 }
// 
//BusOut mbedleds(LED1,LED2,LED3,LED4);
////BusOut/In is faster than multiple DigitalOut/Ins
// 
//class Nav_Switch
//{
//public:
//    Nav_Switch(PinName up,PinName down,PinName left,PinName right,PinName fire);
//    int read();
////boolean functions to test each switch
//    bool up();
//    bool down();
//    bool left();
//    bool right();
//    bool fire();
////automatic read on RHS
//    operator int ();
////index to any switch array style
//    bool operator[](int index) {
//        return _pins[index];
//    };
//private:
//    BusIn _pins;
// 
//};
//Nav_Switch::Nav_Switch (PinName up,PinName down,PinName left,PinName right,PinName fire):
//    _pins(up, down, left, right, fire)
//{
//    _pins.mode(PullUp); //needed if pullups not on board or a bare nav switch is used - delete otherwise
//    wait(0.001); //delays just a bit for pullups to pull inputs high
//}
//inline bool Nav_Switch::up()
//{
//    return !(_pins[0]);
//}
//inline bool Nav_Switch::down()
//{
//    return !(_pins[1]);
//}
//inline bool Nav_Switch::left()
//{
//    return !(_pins[2]);
//}
//inline bool Nav_Switch::right()
//{
//    return !(_pins[3]);
//}
//inline bool Nav_Switch::fire()
//{
//    return !(_pins[4]);
//}
//inline int Nav_Switch::read()
//{
//    return _pins.read();
//}
//inline Nav_Switch::operator int ()
//{
//    return _pins.read();
//}
// 
//Nav_Switch myNav( p9, p6, p7, p5, p8); //pin order on Sparkfun breakout


int main() {
       pin.mode( PullDown );
       pin.attach_asserted( &joyPressed );
       pin.attach_deasserted( &joyReleased );
       pin.setSampleFrequency();
   do{
    //read in the sound file
    FILE *wave_file;
    wave_file = fopen("/sd/countdown.wav", "r");
    led1 = 1;
    //play the countdown sound
    //waver.play(wave_file);
    led1 = 0;
    fclose(wave_file);
   
    pc.printf("START\n\n");
    
    //start the timer
    clock_t startTime = clock();


//    //setup bluetooth
//    char bnum = 0;
//    do{
//       if (blue.getc()=='!') {
//            if (blue.getc()=='B') { //button data
//                bnum = blue.getc(); //button number
//            }
//        }
//    }while(blue.getc() != 'B');
//    


    
    //while joystick or phone button has not been pressed
    pin.attach_asserted_held( &joyPressedHeld );
    pin.attach_deasserted_held( &joyReleasedHeld );


    
        //save time of one that was pressed
        //keep running until one that wasn't pressed is now pressed
        //print over serial
    while(!joyPressedBool || !phonePressedBool){
        led4 = 1;
        char bnum=0;
        char bhit=0;
        if (blue.getc()=='!') {
                    if (blue.getc()=='B') { //button data packet
                        bnum = blue.getc(); //button number
                        bhit = blue.getc(); //1=hit, 0=release
                        if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                            switch (bnum) {
                                case '1': //number button 1
                                if (bhit=='1') {
                                    phoneTime = clock();
                                    phonePressedBool = true;
                                    pc.printf("Player 2 pressed!\n");
                                    led3 = 1;
                                } 
                                                                wait(1);
                                break;

                            }
                       // pc.printf("hgere?1\n\n");
                        }
                    }
   //pc.printf("hgere?2\n\n");
        }
    }
    
   pc.printf("We have a winner! ");
   led1 = 1;
    if(joyTime < phoneTime) {
        pc.printf("Player 1 won!\n\n");
    }else if(phoneTime < joyTime) {
        pc.printf("Player 2 won!\n\n");
    }

    wait(30);
    }while(1);
    
}
