/* SpwfInterface NetworkSocketAPI Example Program
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "SpwfInterface.h"
//#include "NTPClient.h"
//#include "HTTPClient.h"
#include "TCPSocket.h"
#include "DHT11.h"


#define PORT 1234
#define MAX_PENDING 1
/*Thing speak settings */
//NTPClient ntp;
//HTTPClient http;
 
//char* ntpServerUrl = "0.ca.pool.ntp.org";
#define IP "184.106.153.149" 
char* thingSpeakUrl = "http://api.thingspeak.com/update";
char* thingSpeakKey = "SBYDOEXE50MNOBSI";
//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);
AnalogIn   ain(A0);
DHT11 sensor(PA_1);
/*************************************/

//NUCLEO: D8->UART1_TX (PA_9), D2->UART1_RX (PA_10)
SpwfSAInterface spwf(D8, D2, false);
const double Rl      = 10000.0;               // Rl (Ohm) - Load resistance
const double Vadc_5  = 0.0048828125;         // ADC step 5V/1024 4,88mV (10bit ADC)

//const double Vadc_33 = 0.0032226562;         // ADC step 3,3V/1024 3,22mV (10bit ADC)
double Vrl;                                  // Output voltage
double Rs;                                   // Rs (Ohm) - Sensor resistance
double ppm;                                  // ppm
double ratio;
int temp;
int humid;   

//Calculation of PPM
void calculatePPM() 
{
  double lgPPM;
  Vrl = (double)ain*Vadc_5;             // For 5V Vcc use Vadc_5
  Rs = (5 - Vrl)/Vrl;                   // Calculate sensor resistance
  ratio = Rs/Rl;                             // Calculate ratio
  lgPPM = (log10(ratio) * -0.8)+ 0.9;        // Calculate ppm
  ppm = pow(10,lgPPM);                       // Calculate ppm
  pc.printf("The ppm value is %lf \n",ppm);
  pc.printf("The raw Rs is %2.3lf\n",ratio);
  pc.printf("The raw voltage is %2.3lf \n",Vrl);
}

int http_demo(void)
{
    TCPSocket socket(&spwf);
    char buffer[256];
    char message[40];
    int err;
    printf("Sending HTTP Data to thingspeak...\r\n");

    // Open a socket on the network interface, and create a TCP connection to thingspeak
    //socket.open(&spwf);
    err=socket.connect(IP,80); // connecting to thingspeak
    if(err!=0) 
    {
      pc.printf("\r\nCould not connect to Socket, err = %d!!\r\n", err); 
      return -1;
    } else pc.printf("\r\nconnected to host server\r\n"); 
    // Send a simple http request
    //buffer[0] = 0;
    //sprintf(buffer, "GET https://api.thingspeak.com/update?api_key=SBYDOEXE50MNOBSI&field1=%f&field2=%d&field3=%d",(float)ppm,temp,humid);//thingSpeakUrl,thingSpeakKey,
    sprintf(message,"field1=%f&field2=%d&field3=%d",ppm,temp,humid);
    printf("Message Length=%d\r\n",(int)strlen(message));
    sprintf(buffer,"POST /update HTTP/1.1\r\nHost: api.thingspeak.com\r\nConnection: close\r\nX-THINGSPEAKAPIKEY: %s\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: %d\r\n\r\n%s",thingSpeakKey,(int)strlen(message),message);
    pc.printf("Request to %s\r\n", buffer);
    //char sbuffer[] = "GET / HTTP/1.1\r\nHost: www.arm.com\r\n\r\n";
    int scount = socket.send(buffer, (int)strlen(buffer));
    printf("sent %d [%.*s]\r\n", scount, strstr(buffer, "\r\n")-buffer, buffer);

    // Recieve a simple http response and print out the response line
    char rbuffer[64];
    int rcount = socket.recv(rbuffer, sizeof rbuffer);
    printf("recv %d [%.*s]\r\n", rcount, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);

    // Close the socket to return its memory and bring down the network interface
    socket.close();
    return 0;
}

int main() 
{
    int err;    
    char * ssid = "VM957191-2G";
    char * seckey = "krzvzkcw";  
    //char buffer[255];
    //time_t ctTime;
    //Host server(IpAddr(), 123, ntpServerUrl);
    //ntp.setTime(server);
    pc.printf("\r\nAir Quality and Environment monitoring Application\r\n");     
    pc.printf("\r\nconnecting to AP\r\n");
            
    if(spwf.connect(ssid, seckey, NSAPI_SECURITY_WPA2)) {      
        pc.printf("\r\nnow connected\r\n");
    } else {
        pc.printf("\r\nerror connecting to AP.\r\n");
        return -1;
    }   

    const char *ip = spwf.get_ip_address();
    const char *mac = spwf.get_mac_address();
    
    pc.printf("\r\nIP Address is: %s\r\n", (ip) ? ip : "No IP");
    pc.printf("\r\nMAC Address is: %s\r\n", (mac) ? mac : "No MAC");     
    
    while(1) 
    { 
      wait(20);
      myled = !myled;
      calculatePPM();
      err = sensor.readData();
        if (err ==DHT11::OK)
        {
         temp=sensor.readTemperature();
         humid=sensor.readHumidity();
         pc.printf("\r\nT: %d oC, H: %d\r\n",temp,humid);   
        }
         else
         printf("\r\nErr %i \n",err);
         int err=http_demo();
         if(err ==0)
         pc.printf("Thingspeak update completed successfully\r\n");
         else
         pc.printf("Error occurred %d\r\n",err);
       /* buffer[0] = 0;
        sprintf(buffer, "%s?key=%s&field1=%s&field2=%d&field3=%d", thingSpeakUrl, thingSpeakKey, , (float)ppm,temp,humid);
        printf("Request to %s\r\n", buffer);
        
        HTTPText resp;
        HTTPResult res = http.get(buffer, &resp);
        if (res == HTTP_OK)
        {
            printf("Result :\"%s\"\r\n", resp.gets());
        }
        else
        {
            printf("Error %d\r\n", res);
        } */        
             
            
      
    }
    
 
}

