#include "mbed.h" 

/*
Ian McElroy
10/16/18

Displays the start, current, and difference voltage in millivolts on a serial 
output to the user's laptop, and two 7-segment LED displays. 
Uses switch to change to degrees C.
*/

BusOut Ones(p12,p13,p14,p15,p16,p17,p18,p19);// A,B,C,D,E,F,G,DP
BusOut Tens(p21,p22,p23,p24,p25,p26,p27,p28);// A,B,C,D,E,F,G,DP
AnalogIn tempR(p20);

DigitalIn Switch(p7);

float ADCdata;
float mv_to_temp = 10; // mv/C
int v_to_mV = 1000; //convert to mV

char SegConvert(char SegValue);
void displayOnesTens(int number);
Serial pc(USBTX,USBRX);

int main() {

    //float v_ref = 3.3;
    
    float mv_start = tempR*v_to_mV; //get start voltage in mV
    
    float start_tempC = tempR*v_to_mV/mv_to_temp; //convert sensor to temp C
    
    while (1) {
        
        float mv = tempR*v_to_mV; //get voltage in mV
        float tempC = tempR*v_to_mV/mv_to_temp; //convert sensor to temp C
        int diff = abs(rint(mv_start - mv));
        
        if(Switch){ //if switch on, print voltage
            
            pc.printf("Start mv: %.3f, Current mV: %.3f, difference from start mV: %.3f \n\r",mv_start, mv, mv_start-mv);
            displayOnesTens(abs(rint(mv_start - mv)));
        }
        else{//if switch off, print degrees C
            pc.printf("Start temp C: %.3f, Current temp C: %.3f, difference from start temp C: %.3f \n\r",start_tempC, tempC, start_tempC - tempC);
            displayOnesTens(abs(rint(start_tempC - tempC)));
        }
        wait(1);

    }
}

char SegConvert(char SegValue) {
    char SegByte=0x00;
    switch (SegValue) {
        case 0 : SegByte = 0x3F;break; // 00111111 binary
        case 1 : SegByte = 0x06;break; // 00000110 binary
        case 2 : SegByte = 0x5B;break; // 01011011 binary
        case 3 : SegByte = 0x4F;break; // 01001111 binary 
        case 4 : SegByte = 0x66;break; // 01100110 binary
        case 5 : SegByte = 0x6D;break; // 01101101 binary 
        case 6 : SegByte = 0x7D;break; // 01111101 binary 
        case 7 : SegByte = 0x07;break; // 00000111 binary 
        case 8 : SegByte = 0x7F;break; // 01111111 binary 
        case 9 : SegByte = 0x6F;break; // 01101111 binary
    }
    char flip = ~SegByte; //flip since led takes low pin voltage instead of high
    return flip;
}

void displayOnesTens(int number) { 
    //converts number to two seperate hexnumbers for the leds
    int ones = number % 10; //get ones digit
    int tens = number / 10 % 10; //get tens digit
    
    //send to respective displays
    Ones = SegConvert(ones);
    Tens = SegConvert(tens);
    
}