/*#include"mbed.h"
#include"L6470.h"

SPI spi(PinName mosi, PinName miso, PinName ssel);
DigitalOut cs(PinName);

L6470::L6470(const spi_pinmap_t &static_pinmap, PinName ssel)
    :
    static_pinmap(new SPI(mosi,miso,sclk)),
    spi(*static_pinmap),
    ssel = DigitalOut(PinName)
{
    init();
}

L6470::~L6470(){}


/*L6470::L6470(PinName mosi, PinName miso, PinName sclk, PinName ssel)
    :
    spi_p(new SPI(mosi, miso, sclk)),
    spi(*spi_p),
    cs_p(new DigitalOut(ssel)),
    cs(*cs_p)

    
    
void L6470::init(){
    
    // L6470のspi通信の有効化
    //spi.format(8,2);
    //spi.frequency(4960000);
    
    //　nopを送ることで残留している命令を排除
    cs = 1;
    spi.write(0x00);
    spi.write(0x00);
    spi.write(0x00);
    spi.write(0x00);
    cs = 0;
        
    //リセット
    cs = 1;
    spi.write(0xC0);
    cs = 0;
        
    // MAX_SPEED設定。
    cs = 1;
    spi.write(0x07);
    // 最大回転スピード値(10bit) 初期値は 0x41
    spi.write(0x00);
    spi.write(0x23);
    cs = 0;

    // KVAL_HOLD設定。
    /// レジスタアドレス。
    cs = 1;
    spi.write(0x09);
    spi.write(0xFF);
    cs = 0;
        
    // KVAL_spiUN設定。
    /// レジスタアドレス。
    cs = 1;
    spi.write(0x0A);
    spi.write(0xFF);
    cs = 0;
        
    // KVAL_ACC設定。
    cs = 1;
    spi.write(0x0B);
    spi.write(0xFF);
    cs = 0;
        
    // KVAL_DEC設定。
    /// レジスタアドレス。
    cs= 1;
    spi.write(0x0C);
    spi.write(0x40);
    cs = 0;
        
    // OCD_TH設定。
    /// レジスタアドレス。
    cs = 1;
    spi.write(0x13);
    spi.write(0x0F);
    cs = 0;
        
    // STALL_TH設定。
    /// レジスタアドレス。
    cs = 1;
    spi.write(0x14);
    spi.write(0x7F);
    cs = 0;
}

void L6470::writeByte(uint8_t data)
{
    cs = 1;
    spi.write(data);
    cs = 0;
}

    
void L6470::writeBytes(uint8_t add, int bytes, uint32_t value)
{
    uint32_t data[3];
    for (int i = 0; i < bytes; i++){
        data[i] = value & 0xff;
        value = value >> 8;
    }
    if(bytes == 3){
        cs = 1;
        spi.write(add)
        spi.write(data[2]);
        spi.write(data[1]);
        spi.write(data[0]);
        cs_R = 0;
        }
    else if ( bytes == 2 ) {
        cs = 1;
        spi.write( add );
        spi.write( data[1] ) ;
        spi.write( data[0] ) ;
        cs = 0;
    }
    else if ( bytes == 1 ) {
        cs = 1;
        spi.write( add );
        spi.write( data[0] ) ;
        cs = 0;
    }
}


void L6470::L6470_run(uint32_t speed)
{
        uint8_t dir;
        uint32_t spd;
        uint8_t spd_h;
        uint8_t spd_m;
        uint8_t spd_l;

        // 方向検出。
        if (speed < 0)
        {
            dir = 0x50;
            spd = -1 * speed;
        }
        else
        {
            dir = 0x51;
            spd = speed;
        }

        // 送信バイトデータ生成。
        spd_h = (uint8_t)((0x000F0000 & spd) >> 16);
        spd_m = (uint8_t)((0x0000FF00 & spd) >> 8);
        spd_l = (uint8_t)(0x000000FF & spd);
        // コマンド（レジスタアドレス）送信。
        cs = 1;
        spi.write(dir);
        spi.write(spd_h);
        spi.write(spd_m);
        spi.write(spd_l);
        cs = 0;
}    
    
*/