/**
 *  @filename   :   epd1in54b.h
 *  @brief      :   Header file for e-paper display library epd1in54b.cpp
 *  @author     :   Yehui from Waveshare
 *  
 *  Copyright (C) Waveshare     August 10 2017
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documnetation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to  whom the Software is
 * furished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS OR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef EPD1IN54B_H
#define EPD1IN54B_H

#include "epdif.h"
#include "fonts.h"

#define LOW  0
#define HIGH 1

// Display resolution
#define EPD_WIDTH       200
#define EPD_HEIGHT      200

#define  COLORED        1
#define  UNCOLORED      0

// EPD1IN54B commands
#define PANEL_SETTING                               0x00
#define POWER_SETTING                               0x01
#define POWER_OFF                                   0x02
#define POWER_OFF_SEQUENCE_SETTING                  0x03
#define POWER_ON                                    0x04
#define POWER_ON_MEASURE                            0x05
#define BOOSTER_SOFT_START                          0x06
#define DEEP_SLEEP                                  0x07
#define DATA_START_TRANSMISSION_1                   0x10
#define DATA_STOP                                   0x11
#define DISPLAY_REFRESH                             0x12
#define DATA_START_TRANSMISSION_2                   0x13
#define PLL_CONTROL                                 0x30
#define TEMPERATURE_SENSOR_COMMAND                  0x40
#define TEMPERATURE_SENSOR_CALIBRATION              0x41
#define TEMPERATURE_SENSOR_WRITE                    0x42
#define TEMPERATURE_SENSOR_READ                     0x43
#define VCOM_AND_DATA_INTERVAL_SETTING              0x50
#define LOW_POWER_DETECTION                         0x51
#define TCON_SETTING                                0x60
#define TCON_RESOLUTION                             0x61
#define SOURCE_AND_GATE_START_SETTING               0x62
#define GET_STATUS                                  0x71
#define AUTO_MEASURE_VCOM                           0x80
#define VCOM_VALUE                                  0x81
#define VCM_DC_SETTING_REGISTER                     0x82
#define PROGRAM_MODE                                0xA0
#define ACTIVE_PROGRAM                              0xA1
#define READ_OTP_DATA                               0xA2

// Display orientation
#define ROTATE_0                                     0
#define ROTATE_90                                    1
#define ROTATE_180                                   2
#define ROTATE_270                                   3

extern const unsigned char lut_vcom0[];
extern const unsigned char lut_vcom1[];
extern const unsigned char lut_w[];
extern const unsigned char lut_b[];
extern const unsigned char lut_g1[];
extern const unsigned char lut_g2[];
extern const unsigned char lut_red0[];
extern const unsigned char lut_red1[];

class Epd : EpdIf {
public:
    unsigned long width;
    unsigned long height;
    unsigned int rotate;

    Epd(PinName mosi,
        PinName miso,
        PinName sclk, 
        PinName cs, 
        PinName dc, 
        PinName rst, 
        PinName busy
        );
    ~Epd();
    int  Init(void);
    void SendCommand(unsigned char command);
    void SendData(unsigned char data);
    void WaitUntilIdle(void);
    void Reset(void);
    void SetLutBw(void);
    void SetLutRed(void);
    void DisplayFrame(const unsigned char* frame_buffer_black, const unsigned char* frame_buffer_red);
    void Sleep(void);
    void SetRotate(int rotate);
    void SetPixel(unsigned char *frame_buffer, int x, int y, int colored);
    void SetAbsolutePixel(unsigned char *frame_buffer, int x, int y, int colored); 
    void DrawLine(unsigned char *frame_buffer, int x0, int y0, int x1, int y1, int colored);
    void DrawHorizontalLine(unsigned char *frame_buffer, int x, int y, int width, int colored);
    void DrawVerticalLine(unsigned char *frame_buffer, int x, int y, int height, int colored);
    void DrawRectangle(unsigned char *frame_buffer, int x0, int y0, int x1, int y1, int colored);
    void DrawFilledRectangle(unsigned char *frame_buffer, int x0, int y0, int x1, int y1, int colored);
    void DrawCircle(unsigned char *frame_buffer, int x, int y, int radius, int colored);
    void DrawFilledCircle(unsigned char *frame_buffer, int x, int y, int radius, int colored);
    void DrawCharAt(unsigned char *frame_buffer, int x, int y, char ascii_char, sFONT* font, int colored);
    void DrawStringAt(unsigned char *frame_buffer, int x, int y, const char* text, sFONT* font, int colored);


};

#endif /* EPD1IN54B_H */

/* END OF FILE */
