#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include <Semaphore.h>


Semaphore semafor(1);
Thread thread0, thread1, thread2;
bool touch = false;

void test_thread0()
{
    while (true) {
        semafor.acquire();
        BSP_LCD_Clear(LCD_COLOR_DARKBLUE);
        BSP_LCD_SetBackColor(LCD_COLOR_DARKBLUE);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, 50, (uint8_t *)"Jsem vlakno 1", CENTER_MODE); 
        BSP_LCD_DisplayStringAt(0, 80, (uint8_t *)"Stiskni displej", CENTER_MODE); 
    }
}

void test_thread1()
{
    while (true) {
        semafor.acquire();
        BSP_LCD_Clear(LCD_COLOR_BLUE);
        BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, 50, (uint8_t *)"Jsem vlakno 2", CENTER_MODE); 
        BSP_LCD_DisplayStringAt(0, 80, (uint8_t *)"Stiskni displej", CENTER_MODE); 
    }
}

void test_thread2()
{
    while (true) {
        semafor.acquire();
        BSP_LCD_Clear(LCD_COLOR_LIGHTBLUE);
        BSP_LCD_SetBackColor(LCD_COLOR_LIGHTBLUE);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, 50, (uint8_t *)"Jsem vlakno 3", CENTER_MODE); 
        BSP_LCD_DisplayStringAt(0, 80, (uint8_t *)"Stiskni displej", CENTER_MODE); 
    }
}

void display(){  
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    BSP_LCD_Clear(LCD_COLOR_DARKBLUE);
    BSP_LCD_SetFont(&LCD_DEFAULT_FONT);
    BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
}

 void touchScreen(){
    TS_StateTypeDef TS_State;
    uint8_t status;
    status = BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());
    while(1) {
        BSP_TS_GetState(&TS_State);
        if (TS_State.touchDetected) {
          if(!touch) {
             touch = true;
             semafor.release();
          }
          }else{
              touch = false;
          }
        }
}


int main(){
    display();
    thread0.start(test_thread0);
    thread1.start(test_thread1);
    thread2.start(test_thread2);
   touchScreen();
    while(1){
         
           }
}
