#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"

int minutes= 2;
int seconds = 0;

Thread thread0;

    void display(){  
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    BSP_LCD_Clear(LCD_COLOR_BLUE);
    BSP_LCD_SetFont(&LCD_DEFAULT_FONT);
    BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    }
    
    void displayInterface(){
    BSP_LCD_FillRect(20, 120, 80, 80); //tlacitko -
    BSP_LCD_FillRect(380, 120, 80, 80); //tlacito +
    BSP_LCD_FillRect(160, 120, 160, 80); //tlacitko set
    
    BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_DisplayStringAt(-175, 150, (uint8_t *)"-", CENTER_MODE);
    BSP_LCD_DisplayStringAt(185, 150, (uint8_t *)"+", CENTER_MODE);
    BSP_LCD_DisplayStringAt(0, 150, (uint8_t *)"set", CENTER_MODE);
    }

    void printTime() {
    BSP_LCD_Clear(LCD_COLOR_BLUE);
    displayInterface();
    char buffer[20];
    sprintf(buffer, "%02d : %02d", minutes, seconds);
    BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_DisplayStringAt(0, 5, (uint8_t *)buffer, CENTER_MODE);
    }

    void increaseSec (){
    seconds += 10;
    if (seconds > 50){
        seconds = 0;
        minutes++;
    }
    printTime();
    }
    
    void decreaseSec (){
     if (seconds == 0 && minutes != 0){   
        seconds = 50;
        minutes--;
     }else if (seconds > 0 ) {
         seconds -= 10;
     }
    printTime();
    }
   
    void runTimer() {
    while(seconds + minutes > 0) {    
            ThisThread::sleep_for(1000);
            if(seconds == 0) {
                seconds = 59;
                minutes--;
            }
            else {
                seconds--;
            }  
            printTime();
        }
        BSP_LCD_Clear(LCD_COLOR_RED); 
     }

    void defineButtons(uint16_t x, uint16_t y,uint16_t last_x,uint16_t last_y){
    if (x!=last_x && y!=last_y) {
    if(x >= 20 && x <= 100 && y >= 120 && y <= 200){decreaseSec();}
    if(x >= 380 && x <= 460 && y >= 120 && y <= 200){increaseSec();}
    if(x >= 160 && x <= 320 && y >= 120 && y <= 200){runTimer();}
        }
    }
    
    void touchScreen(){
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint16_t last_x=0, last_y=0;
    uint8_t status;
    status = BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());
    uint8_t idx;
    while(1) {
        BSP_TS_GetState(&TS_State);
        if (TS_State.touchDetected) {
            x = TS_State.touchX[0];            
            y = TS_State.touchY[0];    
            defineButtons(x,y,last_x,last_y);   
            last_x=x;
            last_y=y;  
          }
        }
    
    }

    int main()
    {
    display();
    printTime();
    thread0.start(touchScreen);
    while(1){}
    }
