#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "ResetReason.h"
#include <string>


static BufferedSerial pc(USBTX, USBRX);
Thread reading;

std::string reset_reason_to_string(const reset_reason_t reason)
{
    switch (reason) {
        case RESET_REASON_PIN_RESET:
            return "Button Reset";
        case RESET_REASON_SOFTWARE:
            return "Comand Reset";
        case RESET_REASON_WATCHDOG:
            return "Watchdog Reset";
        default:
            return "Other Reason";
    }
}

void read_serial(){
    char *c = new char[1];
    while (1) {
        pc.read(c, sizeof(c));
        if(*c == 'r'){
            NVIC_SystemReset();
        }
    }
}
void display(){
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    BSP_LCD_Clear(LCD_COLOR_BLUE);
    BSP_LCD_SetFont(&LCD_DEFAULT_FONT);
    BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    }

int main() {
    
    display();
    
    const reset_reason_t reason = ResetReason::get();
    
    BSP_LCD_DisplayStringAt(0, 80, (uint8_t *)reset_reason_to_string(reason).c_str(), CENTER_MODE);
    printf("Reason: %s\n", reset_reason_to_string(reason).c_str());
    Watchdog &watchdog = Watchdog::get_instance();
    watchdog.start(5000);
    
    reading.start(read_serial);
    
    while(1) {}

}
