#include "mbed.h" 
#include "stm32746g_discovery_lcd.h" 
#include <inttypes.h> 

#if !defined(MBED_THREAD_STATS_ENABLED) 
#error "Thread statistics not enabled" 
#endif 

#define MAX_THREAD_STATS 0x8 

DigitalOut led(LED1); 

void printText(uint16_t line, uint32_t Color, char text[]) 
{ 
BSP_LCD_SetBackColor(LCD_COLOR_BLUE); 
BSP_LCD_SetTextColor(Color); 
BSP_LCD_DisplayStringAt(0, LINE(line),(uint8_t *)text, CENTER_MODE); 
ThisThread::sleep_for(500); 
BSP_LCD_ClearStringLine(line); 
ThisThread::sleep_for(500); 
} 

void led_thread() 
{ 
while (true) { 
led = !led; 
ThisThread::sleep_for(100); 
} 
} 

void lcd_tread1() 
{ 
uint16_t line = 1; 
uint32_t color = LCD_COLOR_WHITE; 
char text[] = "Ahoj"; 
while (true) { 
printText(line, color, text); 
} 
} 

void lcd_tread2() 
{ 
while (true) { 
BSP_LCD_SetTextColor(LCD_COLOR_LIGHTRED); 
BSP_LCD_FillCircle(100, 200, 36); 
ThisThread::sleep_for(400); 
BSP_LCD_SetTextColor(LCD_COLOR_BLUE); 
BSP_LCD_FillCircle(100, 200, 36); 
ThisThread::sleep_for(400); 
} 
} 

void lcd_tread3() 
{ 
while (true) { 
BSP_LCD_SetTextColor(LCD_COLOR_LIGHTGREEN); 
BSP_LCD_FillRect(250, 166, 70,70); 
ThisThread::sleep_for(800); 
BSP_LCD_SetTextColor(LCD_COLOR_BLUE); 
BSP_LCD_FillRect(250, 166, 70,70); 
ThisThread::sleep_for(800); 
} 
} 

int main() 
{ 
while (1){}
BSP_LCD_Init(); 
BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS); 
BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER); 
BSP_LCD_Clear(LCD_COLOR_BLUE); 
BSP_LCD_SetFont(&LCD_DEFAULT_FONT); 


Thread *thread0 = new Thread(osPriorityNormal, OS_STACK_SIZE, nullptr, "Thread0"); 
Thread *thread1 = new Thread(osPriorityNormal, OS_STACK_SIZE, nullptr, "Thread1"); 
Thread *thread2 = new Thread(osPriorityNormal, OS_STACK_SIZE, nullptr, "Thread2"); 
Thread *thread3 = new Thread(osPriorityNormal, OS_STACK_SIZE, nullptr, "Thread3"); 

thread0->start(led_thread); 
thread1->start(lcd_tread1); 
thread2->start(lcd_tread2); 
thread3->start(lcd_tread3); 

thread_sleep_for(10000); 
mbed_stats_thread_t *stats = new mbed_stats_thread_t[MAX_THREAD_STATS]; 
int count = mbed_stats_thread_get_each(stats, MAX_THREAD_STATS);    
for (int i = 0; i < count; i++) { 
printf("ID: 0x%" PRIx32 "\n", stats[i].id); 
printf("Name: %s \n", stats[i].name); 
printf("State: %" PRId32 "\n", stats[i].state); 
printf("Priority: %" PRId32 "\n", stats[i].priority); 
printf("Stack Size: %" PRId32 "\n", stats[i].stack_size); 
printf("Stack Space: %" PRId32 "\n", stats[i].stack_space); 
printf("\n"); 
while(1){}
)
} 

thread0->terminate(); 
thread1->terminate(); 
thread2->terminate(); 
thread3->terminate(); 
return 0; 


}