#include "mbed.h"
#include "stm32746g_discovery_lcd.h"

InterruptIn sw(USER_BUTTON);
EventQueue queue(32 * EVENTS_EVENT_SIZE);
Thread thread;

void rise_handler(void)
{
    queue.call(BSP_LCD_SetTextColor,LCD_COLOR_RED);
    queue.call(BSP_LCD_FillCircle,200, 100, 50);
}  

void fall_handler(void)
{
    queue.call(BSP_LCD_SetTextColor,LCD_COLOR_BLACK);
    queue.call(BSP_LCD_FillCircle,200, 100, 50);
     }

int main()
{   
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    BSP_LCD_Clear(LCD_COLOR_BLACK);
    
    thread.start(callback(&queue, &EventQueue::dispatch_forever));
    sw.rise(rise_handler);
    sw.fall(fall_handler);
       while (true) {}
}
