#include "mbed.h"
#include "EthernetInterface.h"
#include "Settimino.h"

// PLC INFO
const char* PLC = "10.0.10.51";
const int RACK = 0;
const int SLOT = 2;
const int DB = 21;
const int TOT_DATA = 10;
const int OFFSET = 0;

int main()
{
    EthernetInterface eth; // Ethernet interface for connection
    S7Client client; // Snap7 client
    Serial serial(USBTX, USBRX); // USB serial port
    
    // Check EthernetInferface library handbook for details
    serial.printf("Connect to network...\r\n");
    eth.init(); //Use DHCP
    eth.connect();
    serial.printf("Connected: IP Address is %s\r\n", eth.getIPAddress());
    wait(2);
    
    serial.printf("Connecto to PLC at %s...\r\n", PLC);
    while(!client.Connected)
    {
        if(client.ConnectTo(PLC, RACK, SLOT))
            wait_ms(500);
    }
    serial.printf("Connected: PDU Length = %d\r\n", client.GetPDULength());
    wait(2);
    
    char buffer[32];
    int result;
    serial.printf("Read %d bytes from DB%d, starting at %d...\r\n", TOT_DATA, DB, OFFSET);
    result = client.ReadArea(S7AreaDB,  // Area type
                             DB,        // DB address
                             OFFSET,    // Byte offset
                             TOT_DATA,  // Tot bytes to read
                             buffer);   // buffer that will store read data
    if(result != 0)
    {
        serial.printf("ERROR %d\r\n", result);
    }
    else
    {
        serial.printf("Read data:\r\n");
        for(uint16_t i = 0; i < TOT_DATA; i++)
            serial.printf("%c", buffer[i]);
        serial.printf("\r\n");
    }
    wait(2);
    
    serial.printf("Disconnect from PLC...\r\n");
    client.Disconnect();
    
    serial.printf("Disconnect from network...\r\n");
    eth.disconnect();
    
    serial.printf("\r\n-- Test terminated --\r\n\r\n");
    
    while(1) {}
}
